/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.portforwarder;

import com.sun.jme.toolkit.socket.portforwarder.NoFilterFactory;
import com.sun.jme.toolkit.socket.portforwarder.PortForwarder;
import com.sun.jme.toolkit.socket.portforwarder.ServerThread;
import com.sun.jme.toolkit.socket.portforwarder.StreamFilterFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.log4j.Logger;

public final class PortForwarderImpl
implements PortForwarder {
    private static final Logger logger = Logger.getLogger(PortForwarder.class);
    private int localPort;
    private final InetAddress destAddress;
    private final int destPort;
    private final StreamFilterFactory toDestFilterFactory;
    private final StreamFilterFactory toHostFilterFactory;
    private ServerThread serverThread;

    public PortForwarderImpl(int n, InetAddress inetAddress, int n2) {
        this(n, inetAddress, n2, null, null);
    }

    public PortForwarderImpl(int n, InetAddress inetAddress, int n2, StreamFilterFactory streamFilterFactory, StreamFilterFactory streamFilterFactory2) {
        this.localPort = n;
        this.destAddress = inetAddress;
        this.destPort = n2;
        this.toDestFilterFactory = PortForwarderImpl.getNonNullFilterFactory(streamFilterFactory);
        this.toHostFilterFactory = PortForwarderImpl.getNonNullFilterFactory(streamFilterFactory2);
    }

    @Override
    public void start() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.localPort);
        if (this.localPort == 0) {
            this.localPort = serverSocket.getLocalPort();
        }
        this.serverThread = new ServerThread(this.destAddress, this.destPort, serverSocket, this.toDestFilterFactory, this.toHostFilterFactory);
        this.serverThread.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started forwarding " + this.localPort + " <-> " + this.destAddress.getHostAddress() + ":" + this.destPort + "."));
        }
    }

    @Override
    public void stop() {
        this.serverThread.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopped forwarding " + this.localPort + " <-> " + this.destAddress.getHostAddress() + ":" + this.destPort + "."));
        }
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    private static StreamFilterFactory getNonNullFilterFactory(StreamFilterFactory streamFilterFactory) {
        return streamFilterFactory != null ? streamFilterFactory : NoFilterFactory.getInstance();
    }
}

