/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.portforwarder;

import com.sun.jme.toolkit.socket.portforwarder.SocketCopier;
import com.sun.jme.toolkit.socket.portforwarder.StopListener;
import com.sun.jme.toolkit.socket.portforwarder.StreamFilterFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

final class ServerThread
implements Runnable,
StopListener {
    private final InetAddress destAddress;
    private final int destPort;
    private final ServerSocket serverSocket;
    private final StreamFilterFactory toDestFilterFactory;
    private final StreamFilterFactory toHostFilterFactory;
    private Thread thread;
    private boolean closed;
    private List<SocketCopier> socketCopiers;

    public ServerThread(InetAddress inetAddress, int n, ServerSocket serverSocket, StreamFilterFactory streamFilterFactory, StreamFilterFactory streamFilterFactory2) {
        this.destAddress = inetAddress;
        this.destPort = n;
        this.serverSocket = serverSocket;
        this.socketCopiers = new LinkedList<SocketCopier>();
        this.toDestFilterFactory = streamFilterFactory;
        this.toHostFilterFactory = streamFilterFactory2;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.closeServerSocket();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                SocketCopier socketCopier;
                Object object;
                Socket socket = this.serverSocket.accept();
                try {
                    object = new Socket(this.destAddress, this.destPort);
                    socketCopier = new SocketCopier((Socket)object, socket, this.toHostFilterFactory, this.toDestFilterFactory, this);
                }
                catch (IOException iOException) {
                    socket.close();
                    throw iOException;
                }
                object = this;
                synchronized (object) {
                    socketCopier.start();
                    this.socketCopiers.add(socketCopier);
                }
            }
        }
        catch (IOException iOException) {
            this.stopSocketCopiers();
            this.closeServerSocket();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSocketCopiers() {
        List<SocketCopier> list;
        ServerThread serverThread = this;
        synchronized (serverThread) {
            list = this.socketCopiers;
            this.socketCopiers = null;
        }
        for (SocketCopier socketCopier : list) {
            socketCopier.stop();
        }
    }

    private synchronized void closeServerSocket() {
        if (!this.closed) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    @Override
    public synchronized void stopped(Object object) {
        if (this.socketCopiers != null) {
            this.socketCopiers.remove(object);
        }
    }
}

