/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.portforwarder;

import com.sun.jme.toolkit.socket.portforwarder.StopListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class StreamCopier
implements Runnable {
    private static final int BUFFER_SIZE = 256;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final byte[] buffer;
    private final StopListener listener;
    private Thread thread;
    private boolean closed;

    public StreamCopier(InputStream inputStream, OutputStream outputStream, StopListener stopListener) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.buffer = new byte[256];
        this.listener = stopListener;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.closeStreams();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized boolean isStopped() {
        return this.closed;
    }

    @Override
    public void run() {
        try {
            int n = this.inputStream.read(this.buffer);
            while (n > 0) {
                this.outputStream.write(this.buffer, 0, n);
                n = this.inputStream.read(this.buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStreams() {
        boolean bl = false;
        StreamCopier streamCopier = this;
        synchronized (streamCopier) {
            if (!this.closed) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.closed = true;
                bl = true;
            }
        }
        if (bl && this.listener != null) {
            this.listener.stopped(this);
        }
    }
}

