/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic;

import com.sun.jme.emulator.generic.ArgumentsParser;
import com.sun.kvem.Device;
import com.sun.kvem.environment.DevicePropertyManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractArgumentParser
implements ArgumentsParser {
    protected String syntax;
    protected List<String> arguments;
    protected AtomicInteger deviceIdHolder;

    public void setArguments(List<String> list) {
        this.arguments = list;
    }

    public void setSyntax(String string) {
        this.syntax = string;
    }

    public void setDeviceIdHolder(AtomicInteger atomicInteger) {
        this.deviceIdHolder = atomicInteger;
    }

    @Override
    public String emulatorSyntax() {
        return this.syntax;
    }

    public void create() throws Exception {
        String[] stringArray = new String[this.arguments.size()];
        this.processArguments(this.arguments.toArray(stringArray));
        this.processDeviceProperties();
        this.deviceIdHolder.set(this.getDeviceId());
    }

    @Override
    public void processDeviceProperties() throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)new DevicePropertyManager().getDeviceProperties(AbstractArgumentParser.device()));
        System.getProperties().putAll((Map<?, ?>)properties);
        Device.setProperties((Properties)properties);
    }

    private static String device() {
        String string = System.getProperty("device");
        if (string == null) {
            throw new IllegalArgumentException("Required system property 'device' was not set!");
        }
        return string;
    }
}

