/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.BareContainer;
import com.sun.jme.toolkit.bootstrap.ContainerListener;
import com.sun.jme.toolkit.bootstrap.FileUtils;
import com.sun.jme.toolkit.bootstrap.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public abstract class AbstractContainer
extends BareContainer {
    protected static final String SYSTEM_PROPERTIES_PROPERTY = "system.properties";
    protected static final String MODULES_DIR_PROPERTY = "modules.dir";
    protected static final String MODULES_DIRS_PROPERTY = "modules.dirs";
    protected ContainerListener containerListener;

    public abstract int run(String[] var1) throws Exception;

    public void setContainerListener(ContainerListener containerListener) {
        this.containerListener = containerListener;
    }

    protected void readSystemProperties(Properties properties) throws IOException {
        String string = System.getProperty(SYSTEM_PROPERTIES_PROPERTY);
        if (string == null) {
            return;
        }
        List<String> list = StringUtils.parseList(string);
        FileUtils.mergeProperties(properties, list);
    }

    protected static File modulesDirectory() {
        return new File(StringUtils.mandatorySystemPropertyValue(MODULES_DIR_PROPERTY));
    }

    protected static File[] modulesDirectories() {
        String string = System.getProperty(MODULES_DIRS_PROPERTY);
        if (string == null) {
            return null;
        }
        List<String> list = StringUtils.parseList(string);
        File[] fileArray = new File[list.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(list.get(i));
        }
        return fileArray;
    }
}

