/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.BasicObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.ContainerClassLoader;
import com.sun.jme.toolkit.bootstrap.DeployerManager;
import com.sun.jme.toolkit.bootstrap.Directory;
import com.sun.jme.toolkit.bootstrap.Module;
import com.sun.jme.toolkit.bootstrap.Namespace;
import com.sun.jme.toolkit.bootstrap.PropertyEditorManager;
import com.sun.jme.toolkit.naming.LocalObjectServer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BareContainer
extends DeployerManager {
    private static final Logger LOGGER = Logger.getLogger(BareContainer.class);
    protected Map<String, Module> objectDefinitions = new HashMap<String, Module>();

    public void setModulesDir(File file) {
        this.modulesDir = file;
    }

    public void setModulesDirs(File[] fileArray) {
        this.modulesDirs = fileArray;
    }

    public void initClassLoader(ClassLoader classLoader) {
        this.containerClassLoader = new ContainerClassLoader(classLoader);
        PropertyEditorManager propertyEditorManager = new PropertyEditorManager();
        propertyEditorManager.setClassLoader(this.containerClassLoader);
        propertyEditorManager.create();
        Thread.currentThread().setContextClassLoader(this.containerClassLoader);
        BasicObjectConfiguration.setPropertyEditorManager(propertyEditorManager);
    }

    public Namespace newNamespace() {
        Namespace namespace = new Namespace();
        this.initNamespace(namespace);
        return namespace;
    }

    protected void initNamespace(Namespace namespace) {
        namespace.setContainer(this);
        namespace.setNamingContext(new LocalObjectServer(new HashMap<String, Object>()));
    }

    public Module findObjectDefinition(String string) {
        return this.objectDefinitions.get(string);
    }

    public Set<String> resolveBatch(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        this.resolve(string, hashSet);
        return hashSet;
    }

    private void resolve(String string, Set<String> set) throws IOException {
        Module module = this.objectDefinitions.get(string);
        if (module == null) {
            File file = this.moduleFile(string);
            Directory directory = new Directory();
            directory.initImports(file);
            this.addModuleClasspath(file);
            this.objectDefinitions.put(string, directory);
            List<String> list = directory.getImportedModules();
            if (list != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Module " + string + " requires modules " + list));
                }
                for (String string2 : list) {
                    if (set.contains(string2)) continue;
                    this.resolve(string2, set);
                }
            }
            this.deployDirectory(file, null, null, directory);
        }
        set.add(string);
    }
}

