/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.Batch;
import com.sun.jme.toolkit.bootstrap.Module;
import com.sun.jme.toolkit.bootstrap.PropertyEditorManager;
import com.sun.jme.toolkit.bootstrap.PropertyExpansionHelper;
import com.sun.jme.toolkit.bootstrap.ReflectionUtils;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import org.apache.log4j.Logger;

public abstract class BasicObjectConfiguration
extends Module {
    protected static final Logger LOGGER = Logger.getLogger(BasicObjectConfiguration.class);
    protected List<BasicObjectConfiguration> anonymousChildrenDefinitions;
    protected Map<String, Object> fieldsDefinitions;
    protected String className;
    protected String parentAttachMethod;
    static PropertyEditorManager propertyEditorManager;

    public static void setPropertyEditorManager(PropertyEditorManager propertyEditorManager) {
        BasicObjectConfiguration.propertyEditorManager = propertyEditorManager;
    }

    public void setParentAttachMethod(String string) {
        this.parentAttachMethod = string;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setFieldsDefinitions(Map<String, Object> map) {
        this.fieldsDefinitions = map;
    }

    public void addChildDefinition(BasicObjectConfiguration basicObjectConfiguration) {
        if (this.anonymousChildrenDefinitions == null) {
            this.anonymousChildrenDefinitions = new ArrayList<BasicObjectConfiguration>();
        }
        this.anonymousChildrenDefinitions.add(basicObjectConfiguration);
    }

    public Map<String, Object> getFieldsDefinitions() {
        return this.fieldsDefinitions;
    }

    Object instantiate(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("instantiate " + this.className));
        }
        Class<?> clazz = classLoader.loadClass(this.className);
        return clazz.newInstance();
    }

    void initializeFields(Object object, Class clazz, Context context, Properties properties, ClassLoader classLoader, Object object2, Batch batch, String string) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> initializeFields");
        }
        this.initializeChildren(object, classLoader, context, batch);
        Set<Map.Entry<String, Object>> set = this.fieldsDefinitions.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String string2 = entry.getKey();
            Object object3 = entry.getValue();
            BasicObjectConfiguration.initializeField(object, clazz, string2, this.resolve(object3, object2), context, properties, batch, string);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"< initializeFields");
        }
    }

    Object resolve(Object object, Object object2) {
        if (object.getClass() != String.class) {
            return object;
        }
        return "$parent".equals(((String)object).trim()) ? object2 : object;
    }

    static void initializeField(Object object, Class clazz, String string, Object object2, Context context, Properties properties, Batch batch, String string2) throws Exception {
        Object object3;
        Method method = ReflectionUtils.setterMethod(clazz, string);
        Type type = ReflectionUtils.fieldType(method);
        Class<?> clazz2 = object2.getClass();
        if (clazz2 != String.class && type instanceof Class && ((Class)(object3 = (Class)type)).isAssignableFrom(clazz2)) {
            BasicObjectConfiguration.setReference(object, method, object2);
            return;
        }
        object3 = PropertyExpansionHelper.expandProperties((String)object2, properties);
        PropertyEditor propertyEditor = propertyEditorManager.findEditor(type);
        if (propertyEditor != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Setting field " + string + " to " + (String)object3 + " using " + propertyEditor.getClass()));
            }
            batch.setValue(object, method, (String)object3, propertyEditor, string2);
        } else {
            LOGGER.debug((Object)("Setting field " + string));
            Class<?> clazz3 = method.getParameterTypes()[0];
            String string3 = ((String)object3).trim();
            if (clazz3.isEnum()) {
                Object obj = Enum.valueOf(clazz3, string3);
                BasicObjectConfiguration.setReference(object, method, obj);
            } else {
                Object object4 = context.lookup(string3);
                if (object4 == null) {
                    object4 = BasicObjectConfiguration.mapFieldValue(context, string3);
                }
                if (object4 == null) {
                    LOGGER.warn((Object)("Could not find object " + string3));
                    throw new IllegalArgumentException("Could not find object " + string3);
                }
                batch.setReferenceToObject(object, method, object4, string2, (String)object2);
            }
        }
    }

    private static Object mapFieldValue(Context context, String string) throws Exception {
        String string2;
        Object object;
        int n = string.indexOf(46);
        if (n != -1 && (object = context.lookup(string2 = string.substring(0, n))) != null && object instanceof Map) {
            String string3 = string.substring(n + 1);
            Method method = Map.class.getMethod("get", Object.class);
            return method.invoke(object, string3);
        }
        return null;
    }

    private static void setReference(Object object, Method method, Object object2) throws IllegalAccessException, InvocationTargetException {
        method.invoke(object, object2);
    }

    void attachInstanceToParent(Object object, Object object2, Batch batch, String string, String string2) throws IllegalAccessException, InvocationTargetException {
        Method method = ReflectionUtils.findAddMethod(this.parentAttachMethod, object2.getClass(), object.getClass());
        batch.setReferenceToObject(object2, method, object, string, string2);
        LOGGER.debug((Object)"Attached to parent");
    }

    @Override
    public List<String> getImportedModules() {
        return null;
    }

    void initializeChildren(Object object, ClassLoader classLoader, Context context, Batch batch) throws Exception {
        if (this.anonymousChildrenDefinitions == null) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Initializing children");
        }
        for (BasicObjectConfiguration basicObjectConfiguration : this.anonymousChildrenDefinitions) {
            Object object2 = basicObjectConfiguration.instantiate(classLoader);
            basicObjectConfiguration.initializeFields(object2, object2.getClass(), context, System.getProperties(), classLoader, object, batch, "<>");
            basicObjectConfiguration.attachInstanceToParent(object2, object, batch, "<>", "<>");
        }
    }
}

