/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.BasicObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.ContainerClassLoader;
import com.sun.jme.toolkit.bootstrap.ObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.ObjectGraphProcessor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class Batch
extends ObjectGraphProcessor {
    private static final Logger LOGGER = Logger.getLogger(Batch.class);
    ContainerClassLoader classLoader;
    ClassLoader userClassLoader;
    Properties environment;
    int createIndex;
    int startIndex;

    void setClassLoader(ContainerClassLoader containerClassLoader) {
        this.classLoader = containerClassLoader;
    }

    public void setEnvironment(Properties properties) {
        this.environment = properties;
    }

    public void instantiateObjects() throws Exception {
        this.calculateOrder();
        for (String string : this.objectConfigurations.keySet()) {
            this.instantiateAndRegister(string);
        }
    }

    Object instantiateAndRegister(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NamingException {
        try {
            if (this.namingContext.lookup(string) != null) {
                throw new IllegalStateException("An object already registered under name " + string);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        Object object = this.instantiate(string);
        this.registerObject(object, string);
        return object;
    }

    protected Object instantiate(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        BasicObjectConfiguration basicObjectConfiguration = (BasicObjectConfiguration)this.objectConfigurations.get(string);
        LOGGER.debug((Object)("Instantiating " + string + " class: " + basicObjectConfiguration.className));
        return basicObjectConfiguration.instantiate(this.classLoader);
    }

    private void registerObject(Object object, String string) throws NamingException {
        LOGGER.debug((Object)("Registering object " + string));
        this.namingContext.rebind(string, object);
    }

    public void initializeObjects() throws Exception {
        LOGGER.info((Object)"Initializing objects...");
        for (String string : this.order) {
            this.initializeObject(string);
        }
        this.i18n();
        LOGGER.info((Object)"Initialized objects");
    }

    protected void initializeObject(String string) throws Exception {
        LOGGER.debug((Object)("Initializing object " + string));
        ((ObjectConfiguration)this.objectConfigurations.get(string)).initializeObject(string, this.namingContext, this.environment, this.classLoader, this);
    }

    private void i18n() throws Exception {
        LOGGER.info((Object)"Applying I18N");
        Properties properties = new Properties();
        this.i18nLoad(properties, "en");
        this.i18nLoad(properties, Locale.getDefault().getLanguage());
        this.i18nInit(properties);
    }

    private void i18nInit(Properties properties) throws Exception {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String string = (String)entry.getKey();
            int n = string.indexOf(46);
            if (n == -1) {
                LOGGER.warn((Object)("Invalid key: " + string));
                continue;
            }
            String string2 = string.substring(0, n);
            Object object = this.namingContext.lookup(string2);
            BasicObjectConfiguration.initializeField(object, object.getClass(), string.substring(n + 1), (String)entry.getValue(), this.namingContext, this.environment, this, "<>");
        }
    }

    private void i18nLoad(Properties properties, String string) throws IOException {
        Enumeration<URL> enumeration = this.classLoader.findResources("I18N_" + string + ".properties");
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
        }
    }

    public void startObjects() throws Exception {
        try {
            this.startObjectsImpl();
        }
        catch (Exception exception) {
            this.stopObjects();
            throw exception;
        }
    }

    public void stopObjects() throws Exception {
        LOGGER.info((Object)"Calling stop() methods...");
        while (--this.startIndex >= 0) {
            this.tryInvoke((String)this.order.get(this.startIndex), "stop");
        }
        LOGGER.info((Object)"Calling destroy() methods...");
        while (--this.createIndex >= 0) {
            this.tryInvoke((String)this.order.get(this.createIndex), "destroy");
        }
        LOGGER.info((Object)"Objects stopped");
    }

    void tryInvoke(String string, String string2) throws Exception {
        Object object = this.namingContext.lookup(string);
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string2, new Class[0]);
            this.invoke(string, string2, object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.error((Object)("Problem calling " + string2 + "() on " + string), (Throwable)invocationTargetException);
            throw invocationTargetException;
        }
    }

    protected void invoke(String string, String string2, Object object, Method method) throws IllegalAccessException, InvocationTargetException {
        LOGGER.debug((Object)("Calling " + string2 + " on " + string));
        method.invoke(object, new Object[0]);
        LOGGER.debug((Object)("Called " + string2 + " on " + string));
    }

    protected void setValue(Object object, Method method, String string, PropertyEditor propertyEditor, String string2) throws IllegalAccessException, InvocationTargetException {
        propertyEditor.setAsText(string);
        method.invoke(object, propertyEditor.getValue());
    }

    protected void setReferenceToObject(Object object, Method method, Object object2, String string, String string2) throws IllegalAccessException, InvocationTargetException {
        method.invoke(object, object2);
    }

    public void startObjectsImpl() throws Exception {
        LOGGER.info((Object)"Calling create() methods...");
        this.createIndex = 0;
        while (this.createIndex < this.order.size()) {
            this.tryInvoke((String)this.order.get(this.createIndex), "create");
            ++this.createIndex;
        }
        LOGGER.info((Object)"Calling start() methods...");
        this.startIndex = 0;
        while (this.startIndex < this.order.size()) {
            this.tryInvoke((String)this.order.get(this.startIndex), "start");
            ++this.startIndex;
        }
        LOGGER.info((Object)"Objects started");
    }
}

