/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.AbstractContainer;
import com.sun.jme.toolkit.bootstrap.MainNamespace;
import com.sun.jme.toolkit.bootstrap.MainNamespace_Class;
import com.sun.jme.toolkit.bootstrap.MainNamespace_Latch;
import org.apache.log4j.Logger;

public class Container
extends AbstractContainer {
    private static final Logger LOGGER = Logger.getLogger(Container.class);

    public static void main(String[] stringArray) throws Exception {
        try {
            Container container = new Container();
            container.readSystemProperties(System.getProperties());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("System properties: " + System.getProperties()));
            }
            container.setModulesDirs(Container.modulesDirectories());
            container.setModulesDir(Container.modulesDirectory());
            container.initClassLoader(Thread.currentThread().getContextClassLoader());
            System.exit(((AbstractContainer)container).run(stringArray));
        }
        catch (Exception exception) {
            LOGGER.fatal((Object)exception, (Throwable)exception);
            System.exit(1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOGGER.fatal((Object)noClassDefFoundError, (Throwable)noClassDefFoundError);
            System.exit(1);
        }
    }

    @Override
    public int run(String[] stringArray) throws Exception {
        MainNamespace mainNamespace = this.newMainNamespace();
        this.initNamespace(mainNamespace);
        return mainNamespace.run(stringArray);
    }

    private MainNamespace newMainNamespace() {
        String string = System.getProperty("container.main.namespace.class");
        if (string != null) {
            try {
                return (MainNamespace)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if (System.getProperty("main.class") != null) {
            return new MainNamespace_Class();
        }
        return new MainNamespace_Latch();
    }
}

