/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.DirectoryListUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ContainerClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ContainerClassLoader.class);

    public ContainerClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    void addModuleClasspath(File file) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ContainerClassLoader.addModuleCodeToClasspath(arrayList, file);
        ContainerClassLoader.addModuleConfToClasspath(arrayList, file);
        for (URL uRL : arrayList) {
            LOGGER.debug((Object)("Adding to classpath: " + uRL));
            this.addURL(uRL);
        }
    }

    static void addModuleConfToClasspath(List<URL> list, File file) throws MalformedURLException {
        File file2 = new File(file, "conf");
        if (file2.exists() && file2.isDirectory()) {
            list.add(file2.toURI().toURL());
        }
    }

    public void addFile(File file) {
        try {
            this.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error((Object)("Cannot add file" + file), (Throwable)malformedURLException);
        }
    }

    static void addModuleCodeToClasspath(List<URL> list, File file) throws MalformedURLException {
        File file2 = new File(file, "code");
        if (file2.exists() && file2.isDirectory()) {
            DirectoryListUtils.appendAllFilesInDirectory(list, file2);
        }
    }
}

