/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.ContainerClassLoader;
import com.sun.jme.toolkit.bootstrap.Directory;
import com.sun.jme.toolkit.bootstrap.FileDeployer;
import com.sun.jme.toolkit.bootstrap.FileUtils;
import com.sun.jme.toolkit.bootstrap.Module;
import com.sun.jme.toolkit.bootstrap.ObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.ReflectionUtils;
import com.sun.jme.toolkit.bootstrap.deployer.bean.BeanFileDeployer;
import com.sun.jme.toolkit.bootstrap.deployer.bean.ProtoFileDeployer;
import com.sun.jme.toolkit.bootstrap.deployer.xml.XmlFileDeployer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class DeployerManager {
    static final Logger LOGGER = Logger.getLogger(DeployerManager.class);
    static final String COMMON_PROPERTIES_FILE_NAME = ".common";
    private Map<String, FileDeployer> extension2deployer = new ConcurrentHashMap<String, FileDeployer>();
    private BeanFileDeployer beanFileDeployer = new BeanFileDeployer();
    protected File modulesDir;
    protected File[] modulesDirs;
    protected ContainerClassLoader containerClassLoader;

    public DeployerManager() {
        this.addFileDeployer(this.beanFileDeployer);
        this.addFileDeployer(new ProtoFileDeployer(this));
        this.addFileDeployer(new XmlFileDeployer(this));
    }

    public void addFileDeployer(FileDeployer fileDeployer) {
        this.extension2deployer.put(fileDeployer.fileExtension(), fileDeployer);
    }

    Directory deployDirectory(File file, String string, String string2) throws IOException {
        Directory directory = new Directory();
        this.deployDirectory(file, string, string2, directory);
        return directory;
    }

    void deployDirectory(File file, String string, String string2, Directory directory) throws IOException {
        Map<String, Module> map = directory.createChildrenDefinitions();
        this.deployDirectory(file, string, string2, map);
    }

    void deployDirectory(File file, String string, String string2, Map<String, Module> map) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string3;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Reading object configurations from " + file));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Parent: " + string));
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().startsWith(".");
            }
        });
        File[] fileArray2 = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().equals("code") && !file.getName().equals("conf") && !file.getName().equals("log") && !file.getName().startsWith(".");
            }
        });
        Properties properties = this.commonProperties(file, string);
        LOGGER.debug((Object)"Deploying object files...");
        for (File file2 : fileArray) {
            FileDeployer object4 = this.findDeployer(file2);
            if (object4 == null) {
                string3 = file2.getName();
                if (string3.endsWith(".module")) {
                    object3 = FileUtils.readProperties(file2);
                    object2 = ((Properties)object3).getProperty(".module");
                    object = this.moduleFile((String)object2);
                    this.addModuleClasspath((File)object);
                    this.deployDirectory((File)object, string, null, map);
                    continue;
                }
                LOGGER.warn((Object)("No deployer found for object file " + file2));
                continue;
            }
            string3 = this.objectName(file2);
            object3 = object4.deploy(string, properties, file2, string3);
            if (object3 == null) continue;
            int n = string3.lastIndexOf(46);
            if (n != -1) {
                ((ObjectConfiguration)object3).parent = Module.name(string2, string3.substring(0, n));
                ((ObjectConfiguration)object3).parentAttachMethod = ReflectionUtils.setterName(string3.substring(n + 1));
            }
            map.put(string3, (Module)object3);
        }
        ArrayList arrayList = new ArrayList();
        for (File file2 : fileArray2) {
            string3 = file2.getName();
            object3 = map.get(string3);
            if (object3 != null) {
                object2 = new File(file, string3);
                object = Module.name(string2, ((File)object2).getName());
                ((Module)object3).createChildrenDefinitions();
                this.deployDirectory((File)object2, (String)object, Module.name(string2, ((File)object2).getName()), ((Module)object3).childrenDefinitions);
                continue;
            }
            arrayList.add(file2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            File file3 = (File)iterator.next();
            String string4 = file3.getName();
            if (map.get(string4) != null) continue;
            LOGGER.debug((Object)("Processing directory " + file3));
            map.put(string4, this.deployDirectory(file3, string, Module.name(string2, string4)));
        }
    }

    public FileDeployer findDeployer(File file) {
        String string;
        int n;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Looking for deployer for " + file));
        }
        return (n = (string = file.getName()).lastIndexOf(46)) == -1 ? this.beanFileDeployer : this.findDeployer(string.substring(n + 1));
    }

    public FileDeployer findDeployer(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Looking for deployer for extension " + string));
        }
        return this.extension2deployer.get(string);
    }

    private String objectName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    Properties commonProperties(File file, String string) throws IOException {
        File file2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Creating common properties for dir " + file));
        }
        Properties properties = new Properties();
        if (string != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Default parent: " + string));
            }
            properties.put(".parent", string);
        }
        if ((file2 = new File(file, COMMON_PROPERTIES_FILE_NAME)).exists() && file2.isFile()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Reading common properties from " + file2));
            }
            FileUtils.addPropertiesFromFile(file2, properties);
        }
        return properties;
    }

    protected File moduleFile(String string) {
        File file;
        if (this.modulesDirs != null) {
            for (int i = 0; i < this.modulesDirs.length; ++i) {
                File file2 = this.modulesDirs[i];
                File file3 = new File(file2, string);
                if (!file3.exists()) continue;
                return file3;
            }
        }
        if (!(file = new File(this.modulesDir, string)).exists()) {
            throw new IllegalArgumentException("Cannot find module " + string);
        }
        return file;
    }

    protected void addModuleClasspath(File file) throws MalformedURLException {
        if (this.containerClassLoader != null) {
            this.containerClassLoader.addModuleClasspath(file);
        }
    }
}

