/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectoryListUtils {
    static List<File> subdirectoryList(String string, String string2) {
        return DirectoryListUtils.subdirectoryList(StringUtils.parseList(string), string2);
    }

    static List<File> subdirectoryList(List<String> list, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : list) {
            File file = new File(string2, string);
            if (!file.exists() || !file.isDirectory()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    static URL[] urls(List<File> list) throws MalformedURLException {
        List<URL> list2 = DirectoryListUtils.traverseOneLevel(list);
        return list2.toArray(new URL[list2.size()]);
    }

    static List<URL> traverseOneLevel(File file, List<String> list) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : list) {
            DirectoryListUtils.appendAllFilesInDirectory(arrayList, new File(file, string));
        }
        return arrayList;
    }

    static List<URL> traverseOneLevel(List<File> list) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : list) {
            DirectoryListUtils.appendAllFilesInDirectory(arrayList, file);
        }
        return arrayList;
    }

    static void appendAllFilesInDirectory(List<URL> list, File file) throws MalformedURLException {
        list.addAll(Arrays.asList(DirectoryListUtils.filesInDirectoryAsUrls(file)));
    }

    static URL[] urls(String string) throws MalformedURLException {
        return DirectoryListUtils.filesInDirectoryAsUrls(new File(string));
    }

    static URL[] filesInDirectoryAsUrls(File file) throws MalformedURLException {
        if (!file.exists() || file.isFile()) {
            return new URL[0];
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IllegalArgumentException("Cannot use code in " + file);
        }
        return DirectoryListUtils.toUrlArray(fileArray);
    }

    static URL[] toUrlArray(File[] fileArray) throws MalformedURLException {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            uRLArray[i] = fileArray[i].toURI().toURL();
        }
        return uRLArray;
    }

    static List<URL> toUrlList(List<File> list) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
        for (File file : list) {
            arrayList.add(file.toURI().toURL());
        }
        return arrayList;
    }
}

