/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileUtils {
    static List<String> readListFromFile(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    static void mergeProperties(Properties properties, List<String> list) throws IOException {
        for (String string : list) {
            File file = new File(string);
            if (!file.exists() || !file.isFile()) continue;
            Properties properties2 = FileUtils.readProperties(file);
            properties.putAll((Map<?, ?>)properties2);
        }
    }

    public static Properties readProperties(File file, Properties properties) throws IOException {
        Properties properties2 = new Properties(properties);
        FileUtils.addPropertiesFromFile(file, properties2);
        return properties2;
    }

    static Properties readProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileUtils.addPropertiesFromFile(file, properties);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPropertiesFromFile(File file, Properties properties) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            properties.load(bufferedInputStream);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }
}

