/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.Batch;
import com.sun.jme.toolkit.bootstrap.MainNamespaceMBean;
import com.sun.jme.toolkit.bootstrap.Namespace;
import com.sun.jme.toolkit.bootstrap.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class MainNamespace
extends Namespace
implements MainNamespaceMBean {
    private static final Logger LOGGER = Logger.getLogger(MainNamespace.class);
    private static final long SHUTDOWN_WAIT_TIME = 60000L;
    protected static final String ROOT_OBJECT_PROPERTY = "root.object";
    protected static final String INIT_MODULE_PROPERTY = "init.module";
    protected static final String MODULES_PROPERTY = "modules";
    protected static final String PROCESS_PROPERTY = "process";
    protected CountDownLatch shutdownLatch;
    protected CountDownLatch shutdownFinished;
    protected AtomicInteger returnCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) throws Exception {
        Batch batch = this.startInitModule();
        this.installRootObject();
        this.shutdownLatch = new CountDownLatch(1);
        this.shutdownFinished = new CountDownLatch(1);
        this.returnCode = new AtomicInteger();
        this.registerSingleObject(this, "main-namespace");
        this.registerSingleObject(this.container, "container");
        this.registerSingleObject(this.shutdownLatch, "shutdown-latch");
        this.registerSingleObject(this.shutdownFinished, "shutdown-finished");
        this.registerSingleObject(this.returnCode, "return-code");
        this.registerSingleObject(System.out, "stdout");
        this.registerSingleObject(System.err, "stderr");
        this.registerSingleObject(System.in, "stdin");
        this.registerSingleObject(new ArrayList<String>(Arrays.asList(stringArray)), "args");
        this.installShutdownHook();
        try {
            try {
                this.runModules(stringArray);
            }
            finally {
                if (batch != null) {
                    batch.stopObjects();
                }
            }
        }
        finally {
            this.shutdownFinished.countDown();
            LOGGER.debug((Object)"Shutdown finished");
        }
        return this.returnCode.get();
    }

    private void installRootObject() throws NamingException {
        String string = System.getProperty(ROOT_OBJECT_PROPERTY);
        if (string != null) {
            this.installRootObject(string);
        }
    }

    Batch startInitModule() throws Exception {
        Batch batch = null;
        String string = System.getProperty(INIT_MODULE_PROPERTY);
        if (string != null) {
            batch = this.startBatch(string, System.getProperties());
        }
        return batch;
    }

    void runModules(String[] stringArray) throws Exception {
        List<String> list = MainNamespace.modulesList();
        Batch[] batchArray = new Batch[list.size()];
        int n = 0;
        try {
            for (String string : list) {
                batchArray[n++] = this.startBatch(string, System.getProperties());
            }
            this.main(stringArray);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)throwable, throwable);
            throw new Exception(throwable);
        }
        finally {
            while (--n >= 0) {
                batchArray[n].stopObjects();
            }
        }
    }

    protected abstract void main(String[] var1) throws Exception;

    @Override
    public void shutdown() {
        this.shutdownLatch.countDown();
    }

    static List<String> modulesList() {
        String string = System.getProperty(MODULES_PROPERTY);
        if (string != null) {
            return StringUtils.parseList(string);
        }
        return Arrays.asList(StringUtils.mandatorySystemPropertyValue(PROCESS_PROPERTY));
    }

    private void installShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.debug((Object)"Executing shutdown hook.");
                MainNamespace.this.shutdownLatch.countDown();
                try {
                    MainNamespace.this.shutdownFinished.await(60000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOGGER.debug((Object)"Shutdown hook executed.");
            }
        });
    }
}

