/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.BareContainer;
import com.sun.jme.toolkit.bootstrap.Batch;
import com.sun.jme.toolkit.bootstrap.Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class Namespace {
    private static final Logger LOGGER = Logger.getLogger(Namespace.class);
    transient List<String> loadedModulesList = new ArrayList<String>();
    protected Context namingContext;
    protected BareContainer container;

    public void setNamingContext(Context context) {
        this.namingContext = context;
    }

    public void setContainer(BareContainer bareContainer) {
        this.container = bareContainer;
    }

    public Context getNamingContext() {
        return this.namingContext;
    }

    public void registerSingleObject(Object object, String string) throws NamingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registering object " + string));
        }
        this.namingContext.rebind(string, object);
    }

    public Object findObject(String string) throws Exception {
        return this.namingContext.lookup(string);
    }

    public <T> T findObject(Class<T> clazz, String string) throws Exception {
        return clazz.cast(this.namingContext.lookup(string));
    }

    public void installRootObject(String string) throws NamingException {
        LOGGER.debug((Object)("Installing root object " + string));
        Object object = this.namingContext.lookup(string);
        if (object == null) {
            throw new IllegalArgumentException("Cannot find root object " + string);
        }
        if (!(object instanceof Context)) {
            throw new IllegalArgumentException("Root object must be inherited from Context!");
        }
        this.namingContext = (Context)object;
        this.namingContext.rebind(string, object);
    }

    public Batch startBatch(String string, Properties properties) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting batch, base module " + string));
        }
        Batch batch = this.createBatch(this.container.resolveBatch(string));
        batch.setEnvironment(properties);
        batch.setNamingContext(this.namingContext);
        batch.instantiateObjects();
        batch.initializeObjects();
        batch.startObjects();
        return batch;
    }

    public Batch createBatch(Set<String> set) throws IOException {
        Batch batch = this.newBatch();
        batch.setClassLoader(this.container.containerClassLoader);
        LOGGER.debug((Object)"Created objectConfigurations");
        batch.objectConfigurations = new TreeMap();
        for (String string : this.notLoadedModules(set)) {
            Module module = this.container.findObjectDefinition(string);
            module.addToObjectConfigurations(batch.objectConfigurations, "");
        }
        return batch;
    }

    private Batch newBatch() {
        String string = System.getProperty("container.batch.class");
        if (string != null) {
            try {
                return (Batch)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        return new Batch();
    }

    private List<String> notLoadedModules(Set<String> set) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            if (this.loadedModulesList.contains(string)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Module " + string + " already loaded"));
                continue;
            }
            arrayList.add(string);
            this.loadedModulesList.add(string);
        }
        return arrayList;
    }
}

