/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.BasicObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.ObjectConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ObjectGraphProcessor {
    private static final Logger LOGGER = Logger.getLogger(ObjectGraphProcessor.class);
    protected Context namingContext;
    Map<String, ObjectConfiguration> objectConfigurations;
    transient List<String> order;
    static final int STATE_INITIALIZED = 1;
    static final int STATE_CREATED = 2;
    static final int STATE_STARTED = 3;
    transient Map<String, Integer> states;
    private final Object traversalLock = new Object();

    public void setNamingContext(Context context) {
        this.namingContext = context;
    }

    void calculateOrder() throws Exception {
        this.order = new ArrayList<String>();
        this.states = new HashMap<String, Integer>();
        for (String string : this.objectConfigurations.keySet()) {
            this.states.put(string, 0);
        }
        this.consolidateDependencies();
        LOGGER.info((Object)"Calculating order...");
        this.visitObjects(new SortOrderLogger(), 1, true);
        LOGGER.info((Object)"Calculated order");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Order: " + this.order));
        }
    }

    void consolidateDependencies() {
        LOGGER.info((Object)"Consolidating dependencies...");
        for (String string : this.objectConfigurations.keySet()) {
            LOGGER.debug((Object)("Consolidating dependencies for " + string));
            ObjectConfiguration objectConfiguration = this.objectConfigurations.get(string);
            this.duplicateDependentsAsDependencies(string, objectConfiguration);
            this.duplicateDependenciesAsDependents(string, objectConfiguration);
        }
        LOGGER.info((Object)"Consolidated dependencies...");
    }

    void duplicateDependenciesAsDependents(String string, ObjectConfiguration objectConfiguration) {
        List<String> list = objectConfiguration.getDependencies();
        if (list != null) {
            for (String string2 : list) {
                ObjectConfiguration objectConfiguration2 = this.objectConfigurations.get(string2);
                Object object = this.safeLookup(string2);
                if (objectConfiguration2 != null) {
                    if (object == null) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)("Adding dependent to " + string2 + ": [" + string + " depends on " + string2 + "]"));
                        }
                        objectConfiguration2.addDependent(string);
                        continue;
                    }
                    throw new IllegalArgumentException("An object " + string2 + " is already initialized!");
                }
                if (object != null) continue;
                throw new IllegalArgumentException("Cannot find dependency object: " + string2);
            }
        }
    }

    void duplicateDependentsAsDependencies(String string, ObjectConfiguration objectConfiguration) {
        List<String> list = objectConfiguration.getDependents();
        if (list != null) {
            for (String string2 : list) {
                ObjectConfiguration objectConfiguration2 = this.objectConfigurations.get(string2);
                if (objectConfiguration2 == null) {
                    throw new IllegalStateException("Invalid configuration: object " + string2 + " was not found!");
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Adding dependent to " + string + ": [" + string2 + " depends on " + string + "]"));
                }
                objectConfiguration2.addDependency(string);
            }
        }
    }

    private Object safeLookup(String string) {
        try {
            return this.namingContext.lookup(string);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitObjects(Callable callable, int n, boolean bl) throws Exception {
        Object object = this.traversalLock;
        synchronized (object) {
            try {
                int n2;
                do {
                    n2 = 0;
                    for (String string : this.objectConfigurations.keySet()) {
                        List<String> list;
                        LOGGER.trace((Object)("Processing " + string));
                        ObjectConfiguration objectConfiguration = this.objectConfigurations.get(string);
                        List<String> list2 = list = bl ? objectConfiguration.getDependencies() : objectConfiguration.getDependents();
                        if (this.states.get(string) != n) {
                            if (this.allObjectsHaveState(list, n)) {
                                callable.invoke(string);
                                this.states.put(string, n);
                                ++n2;
                                continue;
                            }
                            LOGGER.trace((Object)("Will process " + string + " later, waiting for dependencies"));
                            continue;
                        }
                        LOGGER.trace((Object)("Skipping " + string + ", already processed"));
                    }
                } while (n2 != 0);
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
            }
        }
    }

    boolean allObjectsHaveState(List<String> list, int n) {
        if (list == null || list.size() == 0) {
            LOGGER.trace((Object)"No dependencies");
            return true;
        }
        LOGGER.trace((Object)"Checking dependencies:");
        LOGGER.trace(list);
        for (String string : list) {
            BasicObjectConfiguration basicObjectConfiguration = this.objectConfigurations.get(string);
            if (basicObjectConfiguration == null || this.states.get(string) == n) continue;
            return false;
        }
        return true;
    }

    class SortOrderLogger
    implements Callable {
        SortOrderLogger() {
        }

        @Override
        public void invoke(String string) throws Exception {
            ObjectGraphProcessor.this.order.add(string);
        }
    }

    static interface Callable {
        public void invoke(String var1) throws Exception;
    }
}

