/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import com.sun.jme.toolkit.bootstrap.GenericsPropertyEditorSupport;
import com.sun.jme.toolkit.bootstrap.ReflectionUtils;
import com.sun.jme.toolkit.propertyeditors.BoolEditor;
import com.sun.jme.toolkit.propertyeditors.BufferedImageEditor;
import com.sun.jme.toolkit.propertyeditors.ByteEditor;
import com.sun.jme.toolkit.propertyeditors.CharEditor;
import com.sun.jme.toolkit.propertyeditors.ColorEditor;
import com.sun.jme.toolkit.propertyeditors.DimensionEditor;
import com.sun.jme.toolkit.propertyeditors.DoubleEditor;
import com.sun.jme.toolkit.propertyeditors.FileEditor;
import com.sun.jme.toolkit.propertyeditors.FloatEditor;
import com.sun.jme.toolkit.propertyeditors.IconEditor;
import com.sun.jme.toolkit.propertyeditors.ImageEditor;
import com.sun.jme.toolkit.propertyeditors.IntArrayEditor;
import com.sun.jme.toolkit.propertyeditors.IntEditor;
import com.sun.jme.toolkit.propertyeditors.LoggerEditor;
import com.sun.jme.toolkit.propertyeditors.LongEditor;
import com.sun.jme.toolkit.propertyeditors.MapEditor;
import com.sun.jme.toolkit.propertyeditors.PointEditor;
import com.sun.jme.toolkit.propertyeditors.RectangleEditor;
import com.sun.jme.toolkit.propertyeditors.ShortEditor;
import com.sun.jme.toolkit.propertyeditors.StringArrayEditor;
import com.sun.jme.toolkit.propertyeditors.StringEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class PropertyEditorManager {
    private static final Logger LOGGER = Logger.getLogger(PropertyEditorManager.class);
    private Map<Class, PropertyEditor> map = new HashMap<Class, PropertyEditor>();
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void create() {
        LOGGER.info((Object)"Registering custom property editors");
        this.registerEditor(Boolean.TYPE, new BoolEditor());
        this.registerEditor(Byte.TYPE, new ByteEditor());
        this.registerEditor(Short.TYPE, new ShortEditor());
        this.registerEditor(Integer.TYPE, new IntEditor());
        this.registerEditor(Long.TYPE, new LongEditor());
        this.registerEditor(Float.TYPE, new FloatEditor());
        this.registerEditor(Double.TYPE, new DoubleEditor());
        this.registerEditor(Character.TYPE, new CharEditor());
        this.registerEditor(String.class, new StringEditor());
        this.registerEditor(int[].class, new IntArrayEditor());
        this.registerEditor(String[].class, new StringArrayEditor());
        this.registerEditor(File.class, new FileEditor());
        this.registerEditor(Map.class, new MapEditor(this));
        this.registerEditor(Icon.class, new IconEditor(this.classLoader));
        this.registerEditor(Image.class, new ImageEditor(this.classLoader));
        this.registerEditor(BufferedImage.class, new BufferedImageEditor(this.classLoader));
        this.registerEditor(Color.class, new ColorEditor());
        this.registerEditor(Dimension.class, new DimensionEditor());
        this.registerEditor(Point.class, new PointEditor());
        this.registerEditor(Rectangle.class, new RectangleEditor());
        this.registerEditor(Logger.class, new LoggerEditor());
    }

    private void registerEditor(Class clazz, PropertyEditor propertyEditor) {
        this.map.put(clazz, propertyEditor);
    }

    public PropertyEditor findEditor(Type type) {
        if (type instanceof Class) {
            PropertyEditor propertyEditor = this.map.get(type);
            if (propertyEditor instanceof GenericsPropertyEditorSupport) {
                ((GenericsPropertyEditorSupport)propertyEditor).clearParameters();
            }
            return propertyEditor;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        PropertyEditor propertyEditor = this.map.get(parameterizedType.getRawType());
        if (propertyEditor instanceof GenericsPropertyEditorSupport) {
            ((GenericsPropertyEditorSupport)propertyEditor).setClassParameters(ReflectionUtils.fieldGenericParameters(type));
        }
        return propertyEditor;
    }
}

