/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class);

    public static Method setterMethod(Class clazz, String string) throws NoSuchMethodException {
        return ReflectionUtils.findSetterMethod(clazz, string);
    }

    private static Method findSetterMethod(Class clazz, String string) {
        Method[] methodArray;
        String string2 = ReflectionUtils.setterName(string);
        for (Method method : methodArray = clazz.getMethods()) {
            if (!string2.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new IllegalArgumentException("Cannot find setter " + string2 + " in class " + clazz.getName());
    }

    static String setterName(String string) {
        return "set" + ReflectionUtils.capitalize(string);
    }

    static Method getterMethod(Class clazz, String string) throws NoSuchMethodException {
        try {
            return clazz.getMethod("get" + ReflectionUtils.capitalize(string), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return clazz.getMethod("is" + ReflectionUtils.capitalize(string), new Class[0]);
        }
    }

    static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static Method findAddMethod(String string, Class clazz, Class clazz2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Looking for method " + string));
            LOGGER.debug((Object)("Class: " + clazz + " " + clazz.getClassLoader()));
        }
        while (true) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.debug((Object)("Trying parameter class: " + clazz2 + " " + clazz2.getClassLoader()));
            }
            try {
                return clazz.getMethod(string, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class clazz3 : ReflectionUtils.getAllInterfaces(clazz2)) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.debug((Object)("Trying parameter class: " + clazz3 + " " + clazz3.getClassLoader()));
                    }
                    try {
                        return clazz.getMethod(string, clazz3);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                throw new IllegalStateException("Could not find " + string + " in hierarchy of " + clazz);
            }
            break;
        }
    }

    static Type fieldType(Method method) {
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != 1) {
            throw new IllegalArgumentException("Setter method is not compliant.");
        }
        return typeArray[0];
    }

    static Class[] fieldGenericParameters(Type type) {
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Type type2 = typeArray[i];
            if (type2 instanceof Class) {
                classArray[i] = (Class)type2;
                continue;
            }
            if (type2 instanceof ParameterizedType) {
                classArray[i] = (Class)((ParameterizedType)type2).getRawType();
                continue;
            }
            if (!(type2 instanceof WildcardType)) continue;
            classArray[i] = (Class)((WildcardType)type2).getUpperBounds()[0];
        }
        return classArray;
    }

    private static void getAllInterfaces0(Class clazz, Set<Class> set) {
        set.add(clazz);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            ReflectionUtils.getAllInterfaces0(clazz2, set);
        }
    }

    private static Class[] getAllInterfaces(Class clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        ReflectionUtils.getAllInterfaces0(clazz, hashSet);
        return hashSet.toArray(new Class[0]);
    }
}

