/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap.deployer.bean;

import com.sun.jme.toolkit.bootstrap.ObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.StringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

class BeanFile
extends ObjectConfiguration {
    static final Logger LOGGER = Logger.getLogger(BeanFile.class);
    static final String PROPERTY_CLASS = ".class";
    static final String PROPERTY_DEPENDENCIES = ".dependencies";
    static final String PROPERTY_DEPENDENTS = ".dependents";
    static final String PROPERTY_PARENT = ".parent";
    static final String PROPERTY_PARENT_ADD_METHOD = ".parent-add-method";

    BeanFile() {
    }

    void init(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        this.fieldsDefinitions = new HashMap();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.startsWith(".")) {
                if (PROPERTY_CLASS.equals(string)) {
                    this.className = string2;
                    continue;
                }
                if (PROPERTY_DEPENDENCIES.equals(string)) {
                    this.dependencies = StringUtils.parseList(string2);
                    continue;
                }
                if (PROPERTY_DEPENDENTS.equals(string)) {
                    this.dependents = StringUtils.parseList(string2);
                    continue;
                }
                if (PROPERTY_PARENT.equals(string)) {
                    this.parent = string2;
                    continue;
                }
                if (PROPERTY_PARENT_ADD_METHOD.equals(string)) {
                    this.parentAttachMethod = string2.trim();
                    continue;
                }
                LOGGER.warn((Object)("Unsupported container property: " + string));
                continue;
            }
            this.fieldsDefinitions.put(string, string2);
        }
        if (this.className == null) {
            throw new IllegalArgumentException("Must specify property .class");
        }
    }
}

