/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bootstrap.deployer.xml;

import com.sun.jme.toolkit.bootstrap.BasicObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.DeployerManager;
import com.sun.jme.toolkit.bootstrap.FileDeployer;
import com.sun.jme.toolkit.bootstrap.ObjectConfiguration;
import com.sun.jme.toolkit.bootstrap.deployer.bean.ProtoBeanFileDeployer;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlFileDeployer
extends DefaultHandler
implements FileDeployer {
    private static final Logger LOGGER = Logger.getLogger(XmlFileDeployer.class);
    private DeployerManager deployerManager;
    private transient LinkedList<BasicObjectConfiguration> currentConfigurations = new LinkedList();
    private transient BasicObjectConfiguration currentConfiguration;
    private transient BasicObjectConfiguration rootConfiguration;

    public XmlFileDeployer(DeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setDeployer(DeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    @Override
    public ObjectConfiguration deploy(String string, Properties properties, File file, String string2) throws IOException {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error((Object)parserConfigurationException, (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LOGGER.error((Object)sAXException, (Throwable)sAXException);
        }
        ObjectConfiguration objectConfiguration = (ObjectConfiguration)this.rootConfiguration;
        if (objectConfiguration.getParent() == null) {
            objectConfiguration.setParent(string);
        }
        return objectConfiguration;
    }

    @Override
    public String fileExtension() {
        return "xml";
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentConfigurations.clear();
        this.currentConfiguration = null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        FileDeployer fileDeployer = this.deployerManager.findDeployer(string3);
        if (!(fileDeployer instanceof ProtoBeanFileDeployer)) {
            throw new IllegalArgumentException("Unsupported element: " + string3);
        }
        ProtoBeanFileDeployer protoBeanFileDeployer = (ProtoBeanFileDeployer)fileDeployer;
        Properties properties = protoBeanFileDeployer.getPrototypeProperties();
        Properties properties2 = new Properties(properties);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            if (string4.startsWith("c:")) {
                if ("c:id".equals(string4)) continue;
                properties2.put("." + string4.substring(2), string5);
                continue;
            }
            properties2.put(string4, string5);
        }
        ObjectConfiguration objectConfiguration = protoBeanFileDeployer.beanFile(null, properties2);
        if (this.currentConfiguration != null) {
            this.currentConfiguration.addChildDefinition(objectConfiguration);
        } else {
            this.rootConfiguration = objectConfiguration;
        }
        this.currentConfiguration = objectConfiguration;
        this.currentConfigurations.add(objectConfiguration);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.currentConfigurations.removeLast();
        this.currentConfiguration = this.currentConfigurations.size() > 0 ? this.currentConfigurations.getLast() : null;
    }
}

