/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.naming;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class LocalObjectServer
implements Context {
    private static final Logger LOGGER = Logger.getLogger(LocalObjectServer.class);
    private Map<String, Object> registry;

    public LocalObjectServer(Map<String, Object> map) {
        this.registry = map;
    }

    void registerObject(Object object, String string) {
        if (!this.registry.containsKey(string)) {
            this.registry.put(string, object);
        }
    }

    void unregisterObject(String string) {
        this.registry.remove(string);
    }

    <T> T findObject(Class<T> clazz, String string) throws Exception {
        Object object = null;
        try {
            object = this.findObject(string);
            return clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            LOGGER.warn((Object)("Cannot cast: " + string + " type of: " + object.getClass().getName() + " to " + clazz.getName() + "\n ClassLoader: " + object.getClass().getClassLoader()), (Throwable)classCastException);
            throw classCastException;
        }
    }

    Object findObject(String string) {
        Object object = this.registry.get(string);
        if (object == null) {
            LOGGER.debug((Object)("Can't find object " + string));
        }
        return object;
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.findObject(string);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.registerObject(object, string);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unregisterObject(string);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

