/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.jme.toolkit.util.MessagePrinter;
import com.sun.mmedia.MediaBridge;
import com.sun.mmedia.MovieFrames;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class JavaCallBridge {
    private static final Logger LOGGER = Logger.getLogger(JavaCallBridge.class);
    private static int counter = 0;
    private static Hashtable<Integer, PlayerData> handleToPlayerId = new Hashtable();
    private static MessagePrinter messagePrinter;

    public void setMessagePrinter(MessagePrinter messagePrinter) {
        JavaCallBridge.messagePrinter = messagePrinter;
    }

    public static long createSoundPlayer(String string, String string2) {
        return JavaCallBridge.createPlayer(string, string2, false);
    }

    public static long createVideoPlayer(String string, String string2) {
        return JavaCallBridge.createPlayer(string, string2, true);
    }

    private static long createPlayer(String string, String string2, boolean bl) {
        LOGGER.debug((Object)("JavaCallBridge.createPlayer " + string2));
        if (null != string2 && !string2.startsWith("capture:")) {
            if (MediaBridge.isFileURL(string2)) {
                string2 = MediaBridge.resolveFileURL(string2);
            }
            if (!JavaCallBridge.isValidURL(string2)) {
                return -1L;
            }
        }
        handleToPlayerId.put(++counter, new PlayerData(string, string2, bl));
        return counter;
    }

    private static boolean isValidURL(String string) {
        boolean bl = true;
        if (MediaBridge.isFileURL(string)) {
            File file = new File(string.substring(MediaBridge.FILE_PROTOCOL_LENGTH));
            if (!file.exists()) {
                bl = false;
            }
        } else if (MediaBridge.isHttpURL(string)) {
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                inputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        LOGGER.debug((Object)("JavaCallBridge.isValidURL " + bl));
        return bl;
    }

    private static int idToPlayerId(int n) {
        PlayerData playerData = handleToPlayerId.get(n);
        return playerData.getPlayerId();
    }

    public static void doBuffering(int n, byte[] byArray) {
        PlayerData playerData = handleToPlayerId.get(n);
        playerData.doBuffering(byArray);
    }

    public static long getDuration(int n) {
        return MediaBridge.getDuration(JavaCallBridge.idToPlayerId(n));
    }

    public static long getTime(int n) {
        return MediaBridge.getMediaTime(JavaCallBridge.idToPlayerId(n)) / 1000L;
    }

    public static void setTime(int n, long l) {
        MediaBridge.setMediaTime(JavaCallBridge.idToPlayerId(n), l * 1000L);
    }

    public static void close(int n) {
        MediaBridge.close(JavaCallBridge.idToPlayerId(n));
        handleToPlayerId.remove(n);
    }

    public static void start(int n) {
        LOGGER.debug((Object)("JavaCallBridge.start() player " + n));
        MediaBridge.start(JavaCallBridge.idToPlayerId(n));
    }

    public static void stop(int n) {
        MediaBridge.stop(JavaCallBridge.idToPlayerId(n));
    }

    public static void setDisplayX(int n, int n2) {
        MediaBridge.setDisplayX(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static void setDisplayY(int n, int n2) {
        MediaBridge.setDisplayY(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static void setDisplayWidth(int n, int n2) {
        MediaBridge.setDisplayWidth(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static void setDisplayHeight(int n, int n2) {
        MediaBridge.setDisplayHeight(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int getSourceWidth(int n) {
        return MediaBridge.getSourceWidth(JavaCallBridge.idToPlayerId(n));
    }

    public static int getSourceHeight(int n) {
        return MediaBridge.getSourceHeight(JavaCallBridge.idToPlayerId(n));
    }

    public static void setVisible(int n, boolean bl) {
        LOGGER.debug((Object)("JavaCallBridge.setVisible() " + bl));
        MediaBridge.setVisible(JavaCallBridge.idToPlayerId(n), bl);
    }

    public static void setDisplayFullScreen(int n, boolean bl) {
        MediaBridge.setDisplayFullScreen(JavaCallBridge.idToPlayerId(n), bl);
    }

    public static void setRate(int n, int n2) {
        MediaBridge.setRate(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int getRate(int n) {
        return (int)MediaBridge.getRate(JavaCallBridge.idToPlayerId(n));
    }

    public static int getMaxRate(int n) {
        return 800000;
    }

    public static int getMinRate(int n) {
        return 10000;
    }

    public static void setVolume(int n, int n2) {
        MediaBridge.setVolume(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int mapFrameToTime(int n, int n2) {
        return (int)MediaBridge.mapFrameToTime(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int mapTimeToFrame(int n, int n2) {
        return MediaBridge.mapTimeToFrame(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int seek(int n, int n2) {
        return MediaBridge.seek(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static int skip(int n, int n2) {
        return MediaBridge.skip(JavaCallBridge.idToPlayerId(n), n2);
    }

    public static void setVideoAlpha(boolean bl, int n) {
        MovieFrames.getInstance().setVideoAlpha(bl, n);
    }

    public static void resume(int n) {
        MediaBridge.resume(JavaCallBridge.idToPlayerId(n));
    }

    public static byte[] snapshot(int n, String string) {
        byte[] byArray;
        if (string != null) {
            string = string.substring(string.indexOf("=") + 1, string.length());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((byArray = MediaBridge.readImage(string, JavaCallBridge.idToPlayerId(n), 0, 256)) != null) {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void put_status_string(String string) {
        if (messagePrinter != null) {
            messagePrinter.printMessage(string);
        }
    }

    static class PlayerData {
        private boolean isVideo = false;
        private int playerId = -1;
        private String mediaType;
        private String URL;
        private ByteArrayOutputStream resourceData = new ByteArrayOutputStream();

        PlayerData(String string, String string2, boolean bl) {
            this.mediaType = string;
            this.URL = string2;
            this.isVideo = bl;
        }

        public void doBuffering(byte[] byArray) {
            try {
                this.resourceData.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private int initPlayer() {
            if (this.resourceData.toByteArray().length > 0) {
                MediaBridge.writeData(this.resourceData.toByteArray());
            }
            MediaBridge.setUrl(this.URL);
            if (this.isVideo) {
                return MediaBridge.createVideo(this.mediaType);
            }
            return MediaBridge.createSound(this.mediaType);
        }

        public int getPlayerId() {
            if (this.playerId == -1) {
                this.playerId = this.initPlayer();
            }
            return this.playerId;
        }
    }
}

