/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.jme.toolkit.util.winreg.NativeException;
import com.sun.jme.toolkit.util.winreg.WindowsRegistry;
import com.sun.kvem.AbstractEMDevice;
import com.sun.kvem.Screen;
import com.sun.kvem.ScreenSpi;
import com.sun.mmedia.Config;
import com.sun.mmedia.JavaCallBridge;
import com.sun.mmedia.MediaException;
import com.sun.mmedia.MediaPlayer;
import com.sun.mmedia.MovieFrames;
import com.sun.mmedia.Player;
import com.sun.mmedia.VideoPlayer;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MediaBridge {
    private static final Logger LOGGER = Logger.getLogger(MediaBridge.class);
    private static Screen screen;
    private AbstractEMDevice screenComponent;
    private static boolean notified;
    private static final String QT_REG_KEY = "SOFTWARE\\Apple Computer, Inc.\\QuickTime";
    private static final String QT_REG_VALUE_NAME = "QTSysDir";
    private static final String QT_JAVA_PARAMETER = "QT_JAVA";
    private static final String QT_JAVA_PROPERTY = "qt.java.path";
    private static Map<Integer, MediaPlayer> players;
    private static Exception error;
    private static int counter;
    private static boolean videoPaused;
    private static InputStream imgInput;
    private static ByteArrayOutputStream resourceData;
    private static String url;
    private static File fileSystemDirectory;
    protected static final String FILE_PROTOCOL = "file://";
    protected static final int FILE_PROTOCOL_LENGTH;
    protected static final String HTTP_PROTOCOL = "http://";
    protected static final int HTTP_PROTOCOL_LENGTH;

    public void start() {
        screen = (Screen)this.screenComponent.getPrimaryScreen();
        MovieFrames.getInstance().setScreen(screen);
        MovieFrames.getInstance().setScreenComponent((JComponent)this.screenComponent);
    }

    public void setScreenComponent(AbstractEMDevice abstractEMDevice) {
        this.screenComponent = abstractEMDevice;
    }

    public static void setFileSystemDirectory(File file) {
        fileSystemDirectory = file;
    }

    public static boolean isFileURL(String string) {
        return string.trim().startsWith(FILE_PROTOCOL);
    }

    public static boolean isHttpURL(String string) {
        return string.trim().startsWith(HTTP_PROTOCOL);
    }

    public static String resolveFileURL(String string) {
        String string2 = string.trim().substring(FILE_PROTOCOL_LENGTH);
        return FILE_PROTOCOL + fileSystemDirectory.getAbsolutePath() + File.separatorChar + string2;
    }

    public static void writeData(byte[] byArray) {
        error = null;
        try {
            if (resourceData == null) {
                resourceData = new ByteArrayOutputStream();
            }
            resourceData.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public void startupAnimation() {
        MediaBridge.setUrl("startup");
        int n = MediaBridge.createVideo(Config.getInstance().getProperty("mmapi.startup.mime"));
        MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
        Rectangle rectangle = screen.getFaceBoundsInImage();
        MediaBridge.setDisplayX(n, (rectangle.width - MediaBridge.getSourceWidth(n)) / 2);
        MediaBridge.setDisplayY(n, (rectangle.height - MediaBridge.getSourceHeight(n)) / 2);
        MediaBridge.start(n);
        try {
            while (mediaPlayer.getMediaTime() < mediaPlayer.getDuration()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
        JavaCallBridge.setVideoAlpha(false, 0);
    }

    public static void setUrl(String string) {
        if (url == null) {
            url = string;
        }
    }

    public static int createSound(String string) {
        error = null;
        int n = -1;
        try {
            n = MediaBridge.init("mmapi.soundPlayer", string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n;
    }

    public static int createVideo(String string) {
        LOGGER.debug((Object)("createVideo " + string));
        error = null;
        int n = -1;
        try {
            n = MediaBridge.init("mmapi.videoPlayer", string);
        }
        catch (Exception exception) {
            LOGGER.fatal((Object)exception, (Throwable)exception);
            error = exception;
        }
        return n;
    }

    private static void notifyUserAboutMissingQT() {
        if (notified) {
            return;
        }
        notified = true;
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setMessageType(1);
        jOptionPane.setMessage(new Object[]{"<html>Cannot find installation of QuickTime.<br>Video and amr playback will not work. <br>If you want to add the support for video and amr, please install QuickTime.</html>"});
        jOptionPane.createDialog(null, "Device Manager - cannot find QT installation").setVisible(true);
    }

    private static int init(String string, String string2) throws MediaException {
        Player player;
        try {
            player = MediaBridge.createPlayer(string);
        }
        catch (Exception exception) {
            MediaBridge.reportError(exception.toString());
            return -1;
        }
        MediaBridge.initPlayer(player, string2);
        resourceData = null;
        url = null;
        return MediaBridge.addPlayer(player);
    }

    private static Player createPlayer(String string) throws Exception {
        File file = MediaBridge.qtJavaPath();
        ClassLoader classLoader = Player.class.getClassLoader();
        classLoader.getClass().getMethod("addFile", File.class).invoke((Object)classLoader, file);
        Class<?> clazz = classLoader.loadClass(Config.getInstance().getProperty(string));
        LOGGER.debug((Object)("playerClass: " + clazz));
        Player player = (Player)clazz.newInstance();
        if (player instanceof VideoPlayer) {
            LOGGER.debug((Object)("setting screen " + screen));
            ((VideoPlayer)player).setScreen((ScreenSpi)screen);
            LOGGER.debug((Object)("set screen " + screen));
        }
        return player;
    }

    private static File qtJavaPath() throws NativeException {
        WindowsRegistry windowsRegistry = WindowsRegistry.getInstance();
        if (!windowsRegistry.keyExists(2, QT_REG_KEY)) {
            MediaBridge.notifyUserAboutMissingQT();
            throw new IllegalStateException("Missing QT installation");
        }
        String string = windowsRegistry.getStringValue(2, QT_REG_KEY, QT_REG_VALUE_NAME);
        LOGGER.debug((Object)("QTSysDir=" + string));
        File file = new File(string, (string.endsWith(File.separator) ? "" : File.separator) + "QTJava.zip");
        if (!file.exists() || file.isDirectory()) {
            MediaBridge.notifyUserAboutMissingQT();
            throw new IllegalStateException("Corrupted QT installation");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addPlayer(Player player) {
        LOGGER.debug((Object)("add player" + player));
        int n = counter++;
        Map<Integer, MediaPlayer> map = players;
        synchronized (map) {
            players.put(n, new MediaPlayer(player, n));
        }
        return n;
    }

    private static void initPlayer(Player player, String string) throws MediaException {
        LOGGER.debug((Object)("init player" + (resourceData != null ? " from resource" : (url != null ? " from url " + url : ""))));
        if (resourceData != null) {
            player.init(resourceData.toByteArray(), string);
        } else if (url.startsWith("capture")) {
            player.init(Config.getFileAsStream((String)Config.getInstance().getProperty("mmapi.camera.file")), Config.getInstance().getProperty("mmapi.camera.mime"));
            player.setMuted(true);
        } else if ("startup".equals(url)) {
            player.init(Config.getFileAsStream((String)Config.getInstance().getProperty("mmapi.startup.file")), Config.getInstance().getProperty("mmapi.startup.mime"));
        } else {
            player.init(url, string);
        }
        LOGGER.debug((Object)"player inited");
    }

    private static void reportError(String string) {
        LOGGER.fatal((Object)("MMAPI error: " + string));
    }

    private static MediaPlayer getPlayer(int n) {
        return players.get(n);
    }

    public static MediaPlayer getMediaPlayer(Player player) {
        for (Map.Entry<Integer, MediaPlayer> entry : players.entrySet()) {
            if (!entry.getValue().getPlayer().equals(player)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void resume(int n) {
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            mediaPlayer.resume();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void start(int n) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            mediaPlayer.start();
            if (mediaPlayer.isVideo()) {
                MovieFrames.getInstance().addMediaPlayer(mediaPlayer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void stop(int n) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void deallocate(int n) {
    }

    public static void close(int n) {
        error = null;
        try {
            MediaPlayer mediaPlayer = players.remove(n);
            if (mediaPlayer != null) {
                mediaPlayer.close();
                if (mediaPlayer.isVideo()) {
                    MovieFrames.getInstance().removeMediaPlayer(mediaPlayer);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static long setMediaTime(int n, long l) {
        error = null;
        long l2 = -1L;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setMediaTime(l);
            }
            l2 = MediaBridge.getMediaTime(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l2;
    }

    public static long mapFrameToTime(int n, int n2) {
        error = null;
        long l = -1L;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            l = mediaPlayer.mapFrameToTime(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l;
    }

    public static int mapTimeToFrame(int n, long l) {
        error = null;
        int n2 = -1;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            n2 = mediaPlayer.mapTimeToFrame(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n2;
    }

    public static int seek(int n, int n2) {
        error = null;
        int n3 = -1;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            n3 = mediaPlayer.seek(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n3;
    }

    public static int skip(int n, int n2) {
        error = null;
        int n3 = -1;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            n3 = mediaPlayer.skip(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n3;
    }

    public static long getMediaTime(int n) {
        error = null;
        long l = -1L;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                l = mediaPlayer.getMediaTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l;
    }

    public static long getDuration(int n) {
        error = null;
        long l = -1L;
        try {
            l = MediaBridge.getPlayer(n).getDuration();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l;
    }

    public static void setRate(int n, long l) {
        error = null;
        try {
            MediaBridge.getPlayer(n).setRate(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static long getRate(int n) {
        error = null;
        long l = -1L;
        try {
            l = MediaBridge.getPlayer(n).getRate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l;
    }

    public static void setVolume(int n, long l) {
        error = null;
        try {
            MediaBridge.getPlayer(n).setVolume(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static long getVolume(int n) {
        long l = -1L;
        error = null;
        try {
            l = MediaBridge.getPlayer(n).getVolume();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return l;
    }

    public static void setDisplayX(int n, int n2) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setXLocation(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void setDisplayY(int n, int n2) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setYLocation(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void setDisplayWidth(int n, int n2) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setWidth(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void setDisplayHeight(int n, int n2) {
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setHeight(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static int getSourceWidth(int n) {
        int n2 = 0;
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                n2 = mediaPlayer.getResourceWidth();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n2;
    }

    public static int getSourceHeight(int n) {
        int n2 = 0;
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                n2 = mediaPlayer.getResourceHeight();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return n2;
    }

    public static void setClippingArea(int n, int n2, int n3, int n4, int n5) {
        error = null;
        try {
            MediaBridge.getPlayer(n).setClippingArea(new Rectangle(n2, n3, n4, n5));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void setVisible(int n, boolean bl) {
        LOGGER.debug((Object)("setVisible: " + bl));
        error = null;
        try {
            MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
            if (mediaPlayer != null) {
                mediaPlayer.setVisible(bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static void setDisplayFullScreen(int n, boolean bl) {
        error = null;
        try {
            MediaBridge.getPlayer(n).setFullScreen(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
    }

    public static byte[] readImage(String string, int n, int n2, int n3) {
        byte[] byArray = null;
        byte[] byArray2 = new byte[n3];
        error = null;
        try {
            int n4;
            if (imgInput == null) {
                MediaPlayer mediaPlayer = MediaBridge.getPlayer(n);
                imgInput = MovieFrames.getInstance().getImageAsStream(mediaPlayer, string);
            }
            if ((n4 = imgInput.read(byArray2, n2, n3)) != -1) {
                byArray = new byte[n4];
                System.arraycopy(byArray2, 0, byArray, 0, n4);
            } else {
                imgInput.close();
                imgInput = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            error = exception;
        }
        return byArray;
    }

    public static boolean isVideoPaused() {
        return videoPaused;
    }

    public static void pauseVideoPlayback() {
        videoPaused = true;
    }

    public static void resumeVideoPlayback() {
        videoPaused = false;
    }

    public static byte[] getError() {
        byte[] byArray = new byte[]{};
        if (error == null) {
            return byArray;
        }
        String string = error.getMessage();
        if (string == null || string.equals("")) {
            string = error.toString();
        }
        try {
            byArray = string.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    static {
        players = new HashMap<Integer, MediaPlayer>();
        counter = 0;
        videoPaused = false;
        imgInput = null;
        resourceData = null;
        url = null;
        FILE_PROTOCOL_LENGTH = FILE_PROTOCOL.length();
        HTTP_PROTOCOL_LENGTH = HTTP_PROTOCOL.length();
    }
}

