/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.kvem.AbstractEMDevice;
import com.sun.kvem.DeviceStateSpi;
import com.sun.kvem.EmulatorRotationListener;
import com.sun.kvem.EmulatorStateListener;
import com.sun.kvem.Orientation;
import com.sun.kvem.Screen;
import com.sun.mmedia.MediaBridge;
import com.sun.mmedia.MediaPlayer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.JComponent;

public class MovieFrames
implements EmulatorRotationListener,
EmulatorStateListener {
    private static final String DEFAULT_IMAGE_TYPE = "jpeg";
    private static final float DEFAULT_QUALITY = 100.0f;
    private static MovieFrames instance;
    private JComponent moviePlayingSurface;
    private int alphaColor = -16777216;
    private Screen screen;
    private JComponent screenComponent;
    private Map<MediaPlayer, MovieFrame> movieFramesMap = new Hashtable<MediaPlayer, MovieFrame>();
    private boolean useColorKeying = false;

    private MovieFrames() {
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    public void setScreenComponent(JComponent jComponent) {
        this.screenComponent = jComponent;
        if (jComponent instanceof AbstractEMDevice) {
            ((AbstractEMDevice)jComponent).addRotationListener((EmulatorRotationListener)this);
            ((AbstractEMDevice)jComponent).addStateListener((EmulatorStateListener)this);
        }
    }

    public static synchronized MovieFrames getInstance() {
        if (instance == null) {
            instance = new MovieFrames();
        }
        return instance;
    }

    public void addMediaPlayer(MediaPlayer mediaPlayer) {
        MovieFrame movieFrame = new MovieFrame(mediaPlayer);
        this.movieFramesMap.put(mediaPlayer, movieFrame);
    }

    public void removeMediaPlayer(MediaPlayer mediaPlayer) {
        this.movieFramesMap.remove(mediaPlayer);
    }

    public void removeAllPlayers() {
        this.movieFramesMap.clear();
    }

    public void notifyRotationChanged(Orientation orientation) {
        this.getMovieComponent().setBounds(this.screen.getCurrentFaceBounds());
    }

    public void notifyStateChanged(DeviceStateSpi deviceStateSpi) {
        this.screen = (Screen)deviceStateSpi.getPrimaryScreen();
        this.getMovieComponent().setBounds(this.screen.getCurrentFaceBounds());
    }

    private void setClippingArea(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return;
        }
        graphics.setClip((int)(rectangle.getX() + rectangle2.getX()), (int)(rectangle.getY() + rectangle2.getY()), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    private void drawFrame(Graphics graphics, Image image, MediaPlayer mediaPlayer, BufferedImage bufferedImage) {
        Rectangle rectangle = mediaPlayer.getMovieBounds();
        this.setClippingArea(graphics, mediaPlayer.getClippingArea(), rectangle);
        graphics.drawImage(this.getFrame(image, bufferedImage), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), this.getMovieComponent());
    }

    private Image getFrame(Image image, BufferedImage bufferedImage) {
        if (this.useColorKeying) {
            return MovieFrames.makeTransparentImage(image, bufferedImage, this.alphaColor);
        }
        return image;
    }

    private static Image makeTransparentImage(Image image, final BufferedImage bufferedImage, final int n) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            int markerRGB;
            {
                this.markerRGB = n | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n4, int n2, int n3) {
                if ((bufferedImage.getRGB(n4, n2) | 0xFF000000) != this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public void updatePlayer(MediaPlayer mediaPlayer) {
        MovieFrame movieFrame = this.movieFramesMap.get(mediaPlayer);
        movieFrame.updatePlayer(mediaPlayer);
    }

    private JComponent getMovieComponent() {
        if (this.moviePlayingSurface == null) {
            this.moviePlayingSurface = new MoviePlayingSurface();
            this.screenComponent.add((Component)this.moviePlayingSurface, 0);
            this.moviePlayingSurface.setBounds(this.screen.getCurrentFaceBounds());
        }
        return this.moviePlayingSurface;
    }

    public void hide() {
        this.setVideoAlpha(false, this.alphaColor);
    }

    public void show() {
        this.setVideoAlpha(true, this.alphaColor);
    }

    public void setVideoAlpha(boolean bl, int n) {
        this.alphaColor = n;
        this.getMovieComponent().setVisible(bl);
        if (bl && this.useColorKeying) {
            this.createMasks();
        }
    }

    private void createMasks() {
        for (MediaPlayer mediaPlayer : this.movieFramesMap.keySet()) {
            MovieFrame movieFrame = this.movieFramesMap.get(mediaPlayer);
            movieFrame.createMask(mediaPlayer);
        }
    }

    public InputStream getImageAsStream(MediaPlayer mediaPlayer, String string) throws IOException {
        BufferedImage bufferedImage = new BufferedImage((int)mediaPlayer.getMovieBounds().getWidth(), (int)mediaPlayer.getMovieBounds().getHeight(), 1);
        MovieFrame movieFrame = this.movieFramesMap.get(mediaPlayer);
        if (movieFrame != null) {
            Image image = movieFrame.getFrame();
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
        return this.encodeImage(bufferedImage, string);
    }

    private InputStream encodeImage(BufferedImage bufferedImage, String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(this.getImageType(string));
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(this.getCompressionQuality(string) / 100.0f);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(memoryCacheImageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        try {
            imageWriter.write(null, iIOImage, imageWriteParam);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private String getImageType(String string) {
        String string2 = this.parseParameter(string, "encoding");
        return string2 == null ? DEFAULT_IMAGE_TYPE : string2;
    }

    private float getCompressionQuality(String string) {
        String string2 = this.parseParameter(string, "quality");
        return string2 == null ? 100.0f : Float.parseFloat(string2);
    }

    private String parseParameter(String string, String string2) {
        int n;
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf("=", n2);
        if (n3 == -1) {
            return null;
        }
        if ((n = string.indexOf("&", ++n3)) == -1) {
            n = string.length();
        }
        return string.substring(n3, n);
    }

    private class MovieFrame {
        private BufferedImage mask;
        private Image frame;

        MovieFrame(MediaPlayer mediaPlayer) {
            if (MovieFrames.this.useColorKeying) {
                this.createMask(mediaPlayer);
            }
            this.frame = MovieFrames.this.getMovieComponent().createImage(mediaPlayer.getImageProducer());
        }

        void createMask(MediaPlayer mediaPlayer) {
            BufferedImage bufferedImage = MovieFrames.this.screen.getFaceImage();
            Rectangle rectangle = mediaPlayer.getMovieBounds();
            this.mask = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        void setMask(BufferedImage bufferedImage) {
            this.mask = bufferedImage;
        }

        BufferedImage getMask() {
            return this.mask;
        }

        void setFrame(Image image) {
            this.frame = image;
        }

        Image getFrame() {
            return this.frame;
        }

        void updatePlayer(MediaPlayer mediaPlayer) {
            if (MovieFrames.this.useColorKeying) {
                this.createMask(mediaPlayer);
            }
        }
    }

    private class MoviePlayingSurface
    extends JComponent {
        public MoviePlayingSurface() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (MediaBridge.isVideoPaused() || MovieFrames.this.movieFramesMap.size() <= 0) {
                return;
            }
            for (MediaPlayer mediaPlayer : MovieFrames.this.movieFramesMap.keySet()) {
                if (!mediaPlayer.isVisible()) continue;
                MovieFrame movieFrame = (MovieFrame)MovieFrames.this.movieFramesMap.get(mediaPlayer);
                MovieFrames.this.drawFrame(graphics, movieFrame.getFrame(), mediaPlayer, movieFrame.getMask());
            }
        }
    }
}

