/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpPortForwarder;
import com.sun.jme.toolkit.socket.portforwarder.PortForwarder;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class DebugHandler {
    private static final String ADDRESS = "address";
    private static final String SERVER = "server";
    private static final String SUSPEND = "suspend";
    private static final String TRANSPORT = "transport";
    private static final Logger logger = Logger.getLogger(DebugHandler.class);
    private PortForwarder pf = null;
    private int port = -1;
    private boolean server = false;
    private boolean suspend = false;
    private DeviceControllerManager deviceControllerManager;

    public DebugHandler(DeviceControllerManager deviceControllerManager) {
        logger.trace((Object)"DebugHandler() -->");
        this.deviceControllerManager = deviceControllerManager;
        logger.trace((Object)"<-- DebugHandler()");
    }

    void attachDebugger(String string, String string2, String[] stringArray) {
        String string3;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("attachDebugger(debugParams = " + string + ", deviceName = " + string2 + ") -->"));
        }
        Object[] objectArray = new String[]{ADDRESS, SERVER, SUSPEND, TRANSPORT};
        String string4 = string.substring("-Xrunjdwp:".length());
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            string3 = stringTokenizer.nextToken();
            logger.debug((Object)("Parsing: " + string3));
            int n = string3.indexOf("=");
            if (n > 0) {
                string5 = string3.substring(0, n);
                String string6 = string3.substring(n + 1);
                if (Arrays.binarySearch(objectArray, string5) >= 0) {
                    properties.put(string5, string6);
                    continue;
                }
                String string7 = "\"" + string3 + "\" is not" + " a valid option for -Xrunjdwp";
                logger.error((Object)string7);
                throw new IllegalArgumentException(string7);
            }
            string5 = "\"" + string3 + "\" is not" + " a valid option for -Xrunjdwp";
            logger.error((Object)string5);
            throw new IllegalArgumentException(string5);
        }
        this.validateJdwpParameters(properties);
        try {
            string3 = this.deviceControllerManager.getOrCreateDeviceController(string2, stringArray);
            this.pf = new JdwpPortForwarder(this.port, InetAddress.getLocalHost(), string3.getJdwpPortNumber());
            try {
                this.pf.start();
            }
            catch (IOException iOException) {
                System.err.println("Cannot start PortForwarder: " + iOException.getMessage());
                logger.error((Object)"Cannot start PortForwarder", (Throwable)iOException);
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot create PortForwarder with necessary parameters: " + exception.getMessage());
            logger.error((Object)"Cannot create PortForwarder with necessary parameters", (Throwable)exception);
        }
        logger.trace((Object)"<-- attachDebugger()");
    }

    void detachDebugger() {
        if (this.pf != null) {
            this.pf.stop();
        }
    }

    void validateJdwpParameters(Properties properties) {
        String string;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("validateJdwpParameters(properties = " + properties.toString() + ") -->"));
        }
        String string2 = properties.getProperty(TRANSPORT);
        String string3 = properties.getProperty(ADDRESS);
        String string4 = properties.getProperty(SERVER);
        String string5 = properties.getProperty(SUSPEND);
        if (string2 == null) {
            System.err.println("No debugging transport specified, using dt_socket");
        } else if (!string2.equals("dt_socket")) {
            String string6 = "The debugging transport \"" + string2 + "\" is not supported.\n" + "Use dt_socket instead.";
            logger.error((Object)string6);
            throw new IllegalArgumentException(string6);
        }
        try {
            this.server = this.yesOrNo(string4);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Debugging mode not specified; running the emulator in server mode");
            this.server = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string7 = "Debugging parameter 'server=" + string4 + "' not recognized";
            logger.error((Object)string7);
            throw new IllegalArgumentException(string7);
        }
        try {
            this.suspend = this.yesOrNo(string5);
        }
        catch (NullPointerException nullPointerException) {
            this.suspend = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string8 = "Debugging parameter 'suspend=" + string4 + "' not recognized";
            logger.error((Object)string8);
            throw new IllegalArgumentException(string8);
        }
        if (string3 == null) {
            String string9 = "Debugging address not specified";
            logger.error((Object)string9);
            throw new IllegalArgumentException(string9);
        }
        int n = string3.indexOf(":");
        if (n != -1) {
            String string10 = string3.substring(0, n);
            string = string3.substring(n + 1);
            if (Boolean.parseBoolean(properties.getProperty(SERVER))) {
                try {
                    if (!this.isLocalHost(string10)) {
                        String string11 = "You can only specify the local host for debugging in server mode";
                        logger.error((Object)string11);
                        throw new IllegalArgumentException(string11);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Cannot resolve host name: ");
                    logger.error((Object)unknownHostException);
                    throw new IllegalArgumentException(unknownHostException.getMessage());
                }
            }
        } else {
            string = string3;
        }
        try {
            this.port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string12 = "Debugging port value " + string + " is out of range. It should be an integer " + "between 1024 and 65535.";
            logger.error((Object)string12);
            throw new IllegalArgumentException(string12);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            throw new IllegalArgumentException(illegalArgumentException.getMessage());
        }
        logger.trace((Object)"<-- validateJdwpParameters()");
    }

    boolean isSuspend() {
        return this.suspend;
    }

    private boolean yesOrNo(String string) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("yesOrNo(s = " + string + ") -->"));
        }
        if (string.equalsIgnoreCase("y")) {
            logger.trace((Object)"<-- yesOrNo() = true");
            return true;
        }
        if (string.equalsIgnoreCase("n")) {
            logger.trace((Object)"<-- yesOrNo() = false");
            return false;
        }
        String string2 = "'" + string + "' is not a valid option ";
        logger.trace((Object)("<-- yesOrNo() = " + string2));
        throw new IllegalArgumentException(string2);
    }

    private boolean isLocalHost(String string) throws UnknownHostException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("isLocalHost(hostname = " + string + ") -->"));
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        InetAddress[] inetAddressArray = InetAddress.getAllByName(inetAddress2.getHostName());
        logger.trace((Object)"<-- isLocalHost()");
        return Arrays.asList(inetAddressArray).contains(inetAddress);
    }
}

