/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.cdcappmanager.api.CdcAppManager;
import com.sun.jme.toolkit.deviceadapter.api.DeviceProperties;
import com.sun.jme.toolkit.ueiproxy.ArgumentHandler;
import com.sun.jme.toolkit.ueiproxy.CdcAppManagerHelper;
import com.sun.jme.toolkit.ueiproxy.CommandHandler;
import com.sun.jme.toolkit.ueiproxy.DebugHandler;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerManager;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.RunOptions;
import com.sun.jme.toolkit.ueiproxy.Task;
import com.sun.jme.toolkit.ueiproxy.TaskListener;
import com.sun.jme.toolkit.ueiproxy.TaskManager;
import com.sun.jme.toolkit.ueiproxy.UEIPropertiesHelper;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import com.sun.jme.toolkit.util.io.FileUtils;
import com.sun.jme.toolkit.util.propstrparser.PropStringParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class Main
implements TaskListener {
    private static final String CONFIGURATION = "Configuration";
    private static final String PROFILE = "Profile";
    private static final String OPTIONAL = "Optional";
    private static final Logger logger = Logger.getLogger(Main.class);
    private List<String> arguments;
    private AtomicInteger returnCode;
    private String fullName;
    private DeviceManagerConnector deviceManagerConnector;
    private String defaultDeviceName;
    private DeviceControllerManager deviceControllerManager;
    private CdcAppManagerHelper cdcAppManagerHelper;
    private List<CommandHandler> handlers = new ArrayList<CommandHandler>();
    private List<ArgumentHandler> argHandlers = new ArrayList<ArgumentHandler>();
    private List<String> defaultCommands = new ArrayList<String>();
    private TaskManager taskManager;
    private CountDownLatch shutdownLatch;
    private DebugHandler debugHandler;

    public Main() {
        logger.trace((Object)"Main() -->");
        logger.trace((Object)"<-- Main()");
    }

    public void setReturnCode(AtomicInteger atomicInteger) {
        this.returnCode = atomicInteger;
    }

    public void setArguments(List<String> list) {
        this.arguments = list;
    }

    public void setDefaultUEICommands(String[] stringArray) {
        for (String string : stringArray) {
            this.defaultCommands.add(string);
        }
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public void setDeviceManagerConnector(DeviceManagerConnector deviceManagerConnector) {
        this.deviceManagerConnector = deviceManagerConnector;
    }

    public void addHandler(Object object) {
        this.handlers.add((CommandHandler)object);
    }

    public void addArgumentHandler(Object object) {
        this.argHandlers.add((ArgumentHandler)object);
    }

    public void setDefaultDevice(String string) {
        this.defaultDeviceName = string;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setShutdownLatch(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    public void setDeviceControllerManager(DeviceControllerManager deviceControllerManager) {
        this.deviceControllerManager = deviceControllerManager;
    }

    public void setCdcAppManagerHelper(CdcAppManagerHelper cdcAppManagerHelper) {
        this.cdcAppManagerHelper = cdcAppManagerHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        String[] stringArray = new String[this.arguments.size()];
        this.arguments.toArray(stringArray);
        try {
            int n = this.prepareArguments(stringArray);
            this.returnCode.set(n);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Main main = this;
        synchronized (main) {
            this.taskManager.addTaskListener((TaskListener)this);
            if (this.taskManager.getActiveTaskCount() == 0) {
                this.taskManager.removeTaskListener((TaskListener)this);
                this.shutdownLatch.countDown();
                logger.debug((Object)("Exiting with status " + this.returnCode.get()));
            }
        }
    }

    public void stop() {
        if (this.debugHandler != null) {
            this.debugHandler.detachDebugger();
        }
    }

    List getSupportedCommands() {
        return this.defaultCommands;
    }

    private int prepareArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            this.printEmulatorSyntax(null);
            return 0;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        RunOptions runOptions = new RunOptions();
        CommandHandler commandHandler = null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            logger.debug((Object)("Processing argument " + stringArray[i]));
            if (stringArray[i].startsWith("-Xmain:")) {
                string4 = stringArray[i];
                continue;
            }
            if (stringArray[i].startsWith("-Xdevice:")) {
                string2 = stringArray[i].substring("-Xdevice:".length());
                continue;
            }
            if (stringArray[i].equals("-version")) {
                this.printVersion();
                return 0;
            }
            if (stringArray[i].startsWith("-Xdomain:")) {
                string3 = stringArray[i].substring("-Xdomain:".length());
                continue;
            }
            if (stringArray[i].equals("-help")) {
                this.printEmulatorSyntax(string2);
                return 0;
            }
            if (stringArray[i].equals("-Xdebug")) {
                bl = true;
                continue;
            }
            if (stringArray[i].startsWith("-Xrunjdwp:")) {
                string5 = stringArray[i];
                continue;
            }
            if (stringArray[i].startsWith("-XconnectArgs:")) {
                int n = stringArray[i].indexOf(58);
                String string6 = stringArray[i].substring(n + 1);
                Main.addToArgs(arrayList3, string6);
                continue;
            }
            ArgumentHandler argumentHandler = this.findArgumentHandler(stringArray[i]);
            if (argumentHandler != null) {
                try {
                    argumentHandler.processArgument(stringArray[i], runOptions);
                    continue;
                }
                catch (UeiProxyException ueiProxyException) {
                    System.out.println(String.format("Cannot process \"" + stringArray[i] + "\" argument.", new Object[0]));
                    System.out.println(ueiProxyException.getMessage());
                    logger.error((Object)("Failed to process \"" + stringArray[i] + "\" argument!"), (Throwable)ueiProxyException);
                    this.printEmulatorSyntax(string2);
                    return 1;
                }
            }
            if (stringArray[i].startsWith("-D")) {
                arrayList3.add(stringArray[i]);
                continue;
            }
            if (i + 1 < stringArray.length && (stringArray[i].equals("-classpath") || stringArray[i].equals("-cp"))) {
                arrayList3.add("-classpath");
                arrayList3.add(FileUtils.normalizeFileListString((String)stringArray[i + 1]));
                ++i;
                continue;
            }
            commandHandler = this.findCommandHandler(stringArray[i]);
            if (commandHandler != null) {
                string = stringArray[i];
                continue;
            }
            if (string4 != null) {
                arrayList2.add(stringArray[i]);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList3.toArray(new String[arrayList3.size()]);
        if (string2 == null && (commandHandler != null || string4 != null) && commandHandler.requiresDeviceName()) {
            try {
                int n = this.deviceManagerConnector.getDeviceId(this.defaultDeviceName);
                string2 = n != -1 ? this.defaultDeviceName : this.deviceManagerConnector.getDefaultDeviceName();
                System.out.println("Device name is not set. Using -Xdevice:" + string2 + " option.");
                System.out.println("Hint: Use -Xquery argument to see all supported devices.\n");
            }
            catch (UeiProxyException ueiProxyException) {
                System.err.println(ueiProxyException.getFormattedMessage());
                logger.error((Object)"Can't get default device ID!", (Throwable)ueiProxyException);
                return 1;
            }
        }
        if (string2 != null && (string != null || string4 != null)) {
            try {
                int n = this.deviceManagerConnector.getRegisteredDeviceId(string2);
                DeviceProperties deviceProperties = this.deviceManagerConnector.getDeviceProperties(n);
                if (!UEIPropertiesHelper.isCommandSupported((String)(string == null ? string4 : string), (String[])deviceProperties.getArguments()) && UEIPropertiesHelper.isCommandSupported((String)(string == null ? string4 : string), (String[])this.defaultCommands.toArray(new String[this.defaultCommands.size()]))) {
                    System.out.println("Device " + string2 + " does not support \"" + (string == null ? string4 : string) + "\" command");
                    logger.trace((Object)"<-- prepareArguments(String[])");
                    return 0;
                }
            }
            catch (UeiProxyException ueiProxyException) {
                System.err.println(ueiProxyException.getFormattedMessage());
                logger.error((Object)"Cannot obtain device properties", (Throwable)ueiProxyException);
                return 1;
            }
        }
        this.debugHandler = null;
        if (bl || string5 != null) {
            if (string != null && string.startsWith("-Xautotest")) {
                System.err.println("-Xautotest cannot be used at the same time as -Xdebug or -Xrunjdwp");
                this.printEmulatorSyntax(string2);
                return 1;
            }
            if (string5 == null) {
                System.err.println("Missing -Xrunjdwp argument necesary for debugger");
                this.printEmulatorSyntax(string2);
                return 1;
            }
            this.debugHandler = new DebugHandler(this.deviceControllerManager);
            try {
                this.debugHandler.attachDebugger(string5, string2, stringArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
                this.printEmulatorSyntax(string2);
                return 1;
            }
            runOptions.setDebug(true);
            runOptions.setSuspend(this.debugHandler.isSuspend());
        }
        if (string4 != null) {
            try {
                string4 = string4.substring("-Xmain:".length());
                DeviceController deviceController = this.deviceControllerManager.getOrCreateDeviceController(string2, stringArray2);
                CdcAppManager cdcAppManager = (CdcAppManager)deviceController.getObjectFromDevice(CdcAppManager.class, "CdcAppManager");
                this.cdcAppManagerHelper.startCdcApplication(deviceController, cdcAppManager, string4, arrayList2.size() > 0 ? arrayList2.toArray(new String[arrayList2.size()]) : new String[]{}, arrayList.size() > 0 ? arrayList.toArray(new String[arrayList.size()]) : new String[]{});
            }
            catch (UeiProxyException ueiProxyException) {
                System.err.println(ueiProxyException.getFormattedMessage());
                logger.error((Object)("Failed to process command \"" + string4 + "\"" + "!"), (Throwable)ueiProxyException);
                return 1;
            }
        } else if (commandHandler != null) {
            try {
                logger.trace((Object)("Going to process command \"" + string + "\"" + " on device \"" + string2 + "\"..."));
                commandHandler.processCommand(string2, stringArray2, string3, runOptions);
                logger.trace((Object)("Command \"" + string + "\" processed" + " successfully."));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(String.format("Cannot process \"%s\" command.", string));
                System.out.println(illegalArgumentException.getMessage());
                logger.error((Object)("Failed to process command \"" + string + "\"!"), (Throwable)illegalArgumentException);
                this.printEmulatorSyntax(string2);
                return 1;
            }
            catch (UeiProxyException ueiProxyException) {
                System.err.println(ueiProxyException.getFormattedMessage());
                logger.error((Object)("Failed to process command \"" + string + "\"!"), (Throwable)ueiProxyException);
                return 1;
            }
        } else {
            this.printEmulatorSyntax(string2);
            return 1;
        }
        return 0;
    }

    private void printVersion() {
        logger.trace((Object)"printVersion() -->");
        System.out.println(this.fullName);
        Main.printManifestInfo(PROFILE);
        Main.printManifestInfo(CONFIGURATION);
        Main.printManifestInfo(OPTIONAL);
        logger.trace((Object)"<-- printVersion()");
    }

    private static void printManifestInfo(String string) {
        logger.trace((Object)"printManifestInfo() -->");
        File[] fileArray = FileUtils.getAPIFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                Manifest manifest = new JarFile(fileArray[i]).getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String string2 = attributes.getValue("API");
                String string3 = attributes.getValue("API-Type");
                String string4 = attributes.getValue("API-Specification-Version");
                if (string2 == null || !string.equals(string3)) continue;
                if (string4 == null) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2 + "-" + string4);
                continue;
            }
            catch (IOException iOException) {
                logger.warn((Object)"IOException", (Throwable)iOException);
            }
        }
        Collections.sort(arrayList);
        System.out.println(string + ": " + UEIPropertiesHelper.list2String(arrayList));
        logger.trace((Object)"<-- printManifestInfo()");
    }

    private void printEmulatorSyntax(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Syntax:\n");
        stringBuffer.append("\n");
        stringBuffer.append("emulator [arguments]\n");
        stringBuffer.append("\n");
        stringBuffer.append("In order to get commands supported by given device run:\n");
        stringBuffer.append("emulator.exe -Xdevice:<device name> -Xquery\n\n");
        stringBuffer.append("Generic list of arguments is:\n");
        stringBuffer.append("\n");
        stringBuffer.append("-version           ");
        stringBuffer.append("Display version information about the emulator\n");
        stringBuffer.append("-help              Display list of valid arguments\n");
        stringBuffer.append("-classpath, -cp    The class path for the VM\n");
        stringBuffer.append("-D<name>=<value>   Set a system property\n");
        stringBuffer.append("-Xdebug            Use a remote debugger\n");
        stringBuffer.append("-Xrunjdwp:[transport=<transport>,address=<address>,server=<y/n>\n");
        stringBuffer.append("           suspend=<y/n>]\n");
        stringBuffer.append("                   Debugging options\n");
        stringBuffer.append("-Xdevice:<device>  Select a device skin for the emulator\n");
        stringBuffer.append("-Xdomain:<domain_name>\n");
        stringBuffer.append("                   Set the MIDlet suite's security domain\n");
        System.out.println(stringBuffer.toString());
        if (string != null) {
            try {
                String[] stringArray;
                int n = this.deviceManagerConnector.getRegisteredDeviceId(string);
                for (String string2 : stringArray = this.deviceManagerConnector.getDeviceProperties(n).getArguments()) {
                    for (ArgumentHandler argumentHandler : this.argHandlers) {
                        if (!argumentHandler.handles("-" + string2)) continue;
                        System.out.println(argumentHandler.getArgumentDescription());
                    }
                    for (CommandHandler commandHandler : this.handlers) {
                        if (!commandHandler.getCommand().substring(1).equals(string2)) continue;
                        System.out.println(commandHandler.getCommandDescription());
                    }
                }
            }
            catch (UeiProxyException ueiProxyException) {
                System.err.println(ueiProxyException.getFormattedMessage());
                logger.error((Object)("Failed to get properties for device \"" + string + "\"!"), (Throwable)ueiProxyException);
            }
        } else {
            this.printArgumentDescriptions();
            this.printCommandDescriptions();
        }
    }

    private void printArgumentDescriptions() {
        for (ArgumentHandler argumentHandler : this.argHandlers) {
            System.out.println(argumentHandler.getArgumentDescription());
        }
    }

    private void printCommandDescriptions() {
        for (CommandHandler commandHandler : this.handlers) {
            System.out.println(commandHandler.getCommandDescription());
        }
    }

    private ArgumentHandler findArgumentHandler(String string) {
        for (ArgumentHandler argumentHandler : this.argHandlers) {
            if (!argumentHandler.handles(string)) continue;
            return argumentHandler;
        }
        return null;
    }

    private CommandHandler findCommandHandler(String string) {
        for (CommandHandler commandHandler : this.handlers) {
            if (!commandHandler.addSupportedCommand(string)) continue;
            return commandHandler;
        }
        return null;
    }

    private static void addToArgs(List<String> list, String string) {
        PropStringParser propStringParser = PropStringParser.createInstance((String)string);
        for (Map.Entry entry : propStringParser) {
            list.add("-" + (String)entry.getKey());
            list.add((String)entry.getValue());
        }
    }

    public synchronized void finished(Task task) {
        if (this.taskManager.getActiveTaskCount() == 0) {
            this.shutdownLatch.countDown();
            logger.debug((Object)("Exiting with status " + this.returnCode.get()));
        }
    }

    public void started(Task task) {
    }
}

