/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.environment;

import com.sun.kvem.environment.KvemHome;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public abstract class Debug {
    private static final int NONE = 0;
    public static final int LIGHT = 1;
    public static final int MEDIUM = 2;
    public static final int HEAVY = 3;
    public static final int EXCESSIVE = 4;
    private static final String INDENT = "    ";
    private static final String[] levelNames = new String[]{"NONE", "LIGHT", "MEDIUM", "HEAVY", "EXCESSIVE"};
    private static boolean showCurrentTime;
    private static final String SHOW_TIME_PROPERTY = "debug.showTime";
    private static boolean debugsDefined;
    private static long propertiesLastRead;
    private static final Debug[] prebuiltDebuggers;
    private static final boolean initialized;
    private static Writer logWriter;

    private static boolean initialize() {
        Debug.loadSystemProperties();
        return true;
    }

    public static void loadSystemProperties() {
        File file = new File(KvemHome.LIB + File.separator + "runtime.properties");
        if (!file.exists()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l < propertiesLastRead + 5000L) {
            return;
        }
        propertiesLastRead = l;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<Object> enumeration = properties.keys();
            Properties properties2 = System.getProperties();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                properties2.setProperty(string, string2.trim());
                if (!string.startsWith("debug") || debugsDefined) continue;
                debugsDefined = true;
                Runtime.getRuntime().addShutdownHook(new Thread("Debug Shutdown Hook"){

                    @Override
                    public void run() {
                        try {
                            if (logWriter != null) {
                                logWriter.close();
                            }
                        }
                        catch (IOException iOException) {
                            System.err.println("Cannot close log file: " + iOException);
                        }
                    }
                });
            }
            ((InputStream)fileInputStream).close();
            Debug.makeLogWriter();
            showCurrentTime = Boolean.getBoolean(SHOW_TIME_PROPERTY);
        }
        catch (IOException iOException) {
            System.err.println("Error loading system properties from " + file);
            System.err.println(iOException);
        }
    }

    public abstract void println(int var1, String var2);

    public abstract void println(int var1, String var2, Object var3);

    public abstract void println(int var1, String var2, int var3);

    public abstract void println(int var1, String var2, Object var3, Object var4);

    public abstract void println(int var1, String var2, int var3, int var4);

    public abstract void println(int var1, String var2, Object var3, int var4);

    public abstract void println(int var1, String var2, int var3, Object var4);

    public abstract boolean level(int var1);

    public abstract void trace(int var1);

    public abstract void exception(int var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Debug create(int n) {
        Debug debug = prebuiltDebuggers[n];
        if (debug != null) return debug;
        Debug[] debugArray = prebuiltDebuggers;
        synchronized (prebuiltDebuggers) {
            if (prebuiltDebuggers[n] != null) return prebuiltDebuggers[n];
            Debug.prebuiltDebuggers[n] = new LevelledDebugger(n);
            return prebuiltDebuggers[n];
        }
    }

    public static synchronized Debug create(Class clazz, String string) {
        String string2 = clazz.getName() + "." + string;
        return Debug.create(string2);
    }

    public static synchronized Debug create(Class clazz) {
        return debugsDefined ? Debug.create(clazz.getName()) : prebuiltDebuggers[0];
    }

    public static synchronized Debug create(String string) {
        if (!debugsDefined) {
            return prebuiltDebuggers[0];
        }
        int n = Debug.getErrorLevel(string);
        boolean bl = Boolean.getBoolean("debug.levels");
        if (bl) {
            System.out.println("debug." + string + ": " + n);
        }
        return Debug.create(n);
    }

    private static void makeLogWriter() {
        String string = System.getProperty("debug.log");
        if (string == null) {
            logWriter = NullWriter.getInstance();
        } else if (logWriter == null || logWriter != null && logWriter instanceof NullWriter) {
            try {
                FileWriter fileWriter = new FileWriter(string);
                logWriter = new BufferedWriter(fileWriter);
            }
            catch (IOException iOException) {
                System.err.println("Cannot open log file '" + string + "': \n" + iOException);
                logWriter = NullWriter.getInstance();
            }
        }
    }

    private static int getErrorLevel(String string) {
        int n;
        block7: {
            n = 0;
            String string2 = string.length() > 0 ? "debug." + string : "debug";
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                if (string.length() > 0) {
                    int n2 = string.lastIndexOf(".");
                    n = n2 == -1 ? Debug.getErrorLevel("") : Debug.getErrorLevel(string.substring(0, n2));
                }
            } else {
                try {
                    n = Integer.parseInt(string3);
                    if (n < 0 || n > 4) {
                        Debug.warning("Error level " + n + " for " + string + " is out of range. Using error level NONE.");
                        n = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    boolean bl = false;
                    for (int i = 0; i < levelNames.length; ++i) {
                        if (!string3.equalsIgnoreCase(levelNames[i])) continue;
                        n = i;
                        bl = true;
                        break;
                    }
                    if (bl) break block7;
                    Debug.warning("Unknown error level '" + string3 + "' for " + string + ". Using error level NONE.");
                }
            }
        }
        return n;
    }

    public static void warning(String string) {
        System.out.println("Warning: " + string);
    }

    public static void error(String string) {
        System.out.println("Error: " + string);
    }

    public static void assertTrue(boolean bl) {
        if (!bl) {
            Debug.println("Assertion failed", new String[0]);
            System.exit(1);
        }
    }

    public static void assertEquals(Object object, Object object2) {
        if (object == null && object2 != null) {
            Debug.assertTrue(false);
        } else {
            Debug.assertTrue(object == object2 || object.equals(object2));
        }
    }

    public static void assertValid(Object object) {
        Debug.assertTrue(object != null);
    }

    private static String convertArrayToString(Object object, String string) {
        String string2;
        int n = Array.getLength(object);
        if (n < 2) {
            if (n == 1) {
                Object object2 = Array.get(object, 0);
                string2 = "{ " + Debug.convertArrayElementToString(object2, string) + " }";
            } else {
                string2 = "{ }";
            }
        } else {
            string2 = string + "{\n";
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                string2 = string2 + INDENT + Debug.convertArrayElementToString(object3, string) + "\n";
            }
            string2 = string2 + string + "}";
        }
        return string2;
    }

    private static String convertArrayElementToString(Object object, String string) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return Debug.convertArrayToString(object, string + INDENT + INDENT);
        }
        if (object instanceof Number || object instanceof Boolean) {
            return String.valueOf(object);
        }
        return Debug.quote(object);
    }

    private static String quote(Object object) {
        String string = object.toString().replaceAll("\r", "^M");
        return "\"" + string + "\"";
    }

    private static String format(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return Debug.convertArrayToString(object, "");
        }
        return Debug.quote(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void println(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(string, objectArray);
        String string3 = Debug.className(false) + ": ";
        if (showCurrentTime) {
            string3 = Debug.currentTime() + " " + string3;
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Debug.print(string3);
            int n = string2.indexOf("\n");
            int n2 = 0;
            while (n != -1) {
                Debug.println(string2.substring(n2, n));
                Debug.print(string3);
                n2 = n + 1;
                n = string2.indexOf("\n", n2);
            }
            Debug.println(string2.substring(n2));
        }
    }

    private static void println(String string) {
        Debug.print(string + '\n');
    }

    private static void print(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u007f' || c < ' ' && c != '\r' && c != '\n') {
                stringBuffer.append("\\u");
                String string2 = Integer.toHexString(c);
                for (int j = string2.length(); j < 4; ++j) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        string = stringBuffer.toString();
        try {
            System.out.print(string);
            logWriter.write(string);
        }
        catch (IOException iOException) {
            logWriter = NullWriter.getInstance();
            System.err.println("Error writing to the log file: " + iOException);
        }
    }

    private static synchronized String className(boolean bl) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        Throwable throwable = new Throwable();
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        char[] cArray = charArrayWriter.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        String string = "";
        try {
            while (!string.startsWith("at com.sun.kvem.environment.Debug")) {
                string = bufferedReader.readLine().trim();
            }
            while (string.startsWith("at com.sun.kvem.environment.Debug.") || string.startsWith("at com.sun.kvem.environment.Debug$")) {
                string = bufferedReader.readLine().trim();
            }
        }
        catch (IOException iOException) {
            return "";
        }
        string = string.substring(3);
        while (Character.isLowerCase(string.charAt(0))) {
            int n = string.indexOf(".");
            string = string.substring(n + 1);
        }
        int n = string.indexOf("(");
        String string2 = string.substring(0, n).trim();
        if (bl) {
            string2 = string2.replace('$', '.');
        } else {
            n = string2.lastIndexOf(".");
            if ((n = (string2 = string2.substring(0, n)).indexOf("$")) != -1) {
                string2 = string2.substring(0, n);
            }
        }
        int n2 = string.lastIndexOf(":");
        String string3 = string.substring(n2 + 1);
        n2 = string3.indexOf(")");
        string3 = string3.substring(0, n2);
        return string2 + ":" + string3;
    }

    private static String currentTime() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    static {
        propertiesLastRead = 0L;
        prebuiltDebuggers = new Debug[]{new NullDebugger(), null, null, null, null};
        initialized = Debug.initialize();
        logWriter = NullWriter.getInstance();
    }

    private static class LevelledDebugger
    extends Debug {
        private final int errorLevel;

        LevelledDebugger(int n) {
            this.errorLevel = n;
        }

        @Override
        public void println(int n, String string) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[0]);
            }
        }

        @Override
        public void println(int n, String string, Object object) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{Debug.format(object)});
            }
        }

        @Override
        public void println(int n, String string, int n2) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{new Integer(n2)});
            }
        }

        @Override
        public void println(int n, String string, Object object, Object object2) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{Debug.format(object), Debug.format(object2)});
            }
        }

        @Override
        public void println(int n, String string, int n2, int n3) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{new Integer(n2), new Integer(n3)});
            }
        }

        @Override
        public void println(int n, String string, Object object, int n2) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{Debug.format(object), new Integer(n2)});
            }
        }

        @Override
        public void println(int n, String string, int n2, Object object) {
            if (n <= this.errorLevel) {
                LevelledDebugger.println(string, new Object[]{new Integer(n2), Debug.format(object)});
            }
        }

        @Override
        public boolean level(int n) {
            return n <= this.errorLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trace(int n) {
            if (n <= this.errorLevel) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    if (showCurrentTime) {
                        System.out.print(Debug.currentTime() + " ");
                    }
                    System.out.println(Debug.className(true) + ": " + " trace(" + n + ")");
                }
            }
        }

        @Override
        public void exception(int n, Throwable throwable) {
            if (n <= this.errorLevel) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                LevelledDebugger.println("{0}", new Object[]{stringWriter});
            }
        }
    }

    private static class NullDebugger
    extends Debug {
        private NullDebugger() {
        }

        @Override
        public void println(int n, String string) {
        }

        @Override
        public void println(int n, String string, Object object) {
        }

        @Override
        public void println(int n, String string, int n2) {
        }

        @Override
        public void println(int n, String string, Object object, Object object2) {
        }

        @Override
        public void println(int n, String string, int n2, int n3) {
        }

        @Override
        public void println(int n, String string, Object object, int n2) {
        }

        @Override
        public void println(int n, String string, int n2, Object object) {
        }

        @Override
        public boolean level(int n) {
            return false;
        }

        @Override
        public void trace(int n) {
        }

        @Override
        public void exception(int n, Throwable throwable) {
        }
    }

    private static class NullWriter
    extends Writer {
        private static Writer instance = new NullWriter();

        private NullWriter() {
        }

        private static Writer getInstance() {
            return instance;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
        }
    }
}

