/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.environment;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.util.ToolkitResources;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

@Deprecated
public class DevicePropertyManager {
    private static final Logger LOGGER = Logger.getLogger(DevicePropertyManager.class);
    private static final Debug debug = Debug.create(DevicePropertyManager.class);
    public static final String DEVICE_PATH = "kvem.device.url";
    public static final String DEVICE_FILE = "kvem.device.file";
    public static final String DEVICE_NAME = "kvem.device.name";
    private final File devicesDir;
    private Map deviceLocationMap;
    private final Map devicePropertyMap = new HashMap();
    private String[] deviceList;

    public DevicePropertyManager() {
        this.devicesDir = new File(System.getProperty("modules.dir"), "devices");
    }

    public boolean deviceExists(String string) {
        File file = this.getDeviceFile(string);
        boolean bl = file != null && file.exists();
        debug.println(2, "deviceExists() device {0}, exists={1}", (Object)string, (Object)String.valueOf(bl));
        return bl;
    }

    public String[] getDeviceList() {
        if (this.deviceList == null) {
            Map map = this.getDeviceMap();
            this.deviceList = map.keySet().toArray(new String[map.size()]);
            Arrays.sort(this.deviceList);
        }
        return (String[])this.deviceList.clone();
    }

    private Map getDeviceMap() {
        if (this.deviceLocationMap == null) {
            this.deviceLocationMap = this.findDevices();
        }
        return this.deviceLocationMap;
    }

    private Map findDevices() {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        if (this.devicesDir == null) {
            return hashMap;
        }
        String[] stringArray = this.devicesDir.list();
        if (stringArray != null) {
            for (String string : stringArray) {
                File file = new File(this.devicesDir, string + "/conf");
                if (!file.isDirectory()) continue;
                File file2 = new File(file, "index.txt");
                if (file2.exists()) {
                    this.readDeviceList(file2, hashMap);
                    continue;
                }
                File file3 = new File(file, string + ".properties");
                if (!file3.exists()) continue;
                hashMap.put(string, file3);
            }
        }
        debug.println(3, "findDevices() returning {0}", hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDeviceList(File file, Map map) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = file.getParent();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                String string3 = properties.getProperty(string2, string + "/" + string2);
                File file2 = new File(string2);
                if (!file2.isAbsolute()) {
                    file2 = new File(string, string2);
                }
                map.put(string3, file2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getDeviceFile(String string) {
        Map map = this.getDeviceMap();
        File file = (File)map.get(string);
        if (file == null) {
            file = new File(this.devicesDir, string + File.separator + "conf" + File.separator + string + ".properties");
        }
        return file;
    }

    private Properties getDevicePropertiesImp(String string) throws IOException {
        if (!this.devicePropertyMap.containsKey(string)) {
            this.tryToFillFromFile(string);
        }
        return (Properties)this.devicePropertyMap.get(string);
    }

    private void tryToFillFromFile(String string) throws IOException {
        LOGGER.debug((Object)("Reading device properties for device '" + string + '\''));
        File file = this.getDeviceFile(string);
        LOGGER.debug((Object)("Reading device properties from file '" + file + '\''));
        try {
            URL uRL = file.toURI().toURL();
            String string2 = uRL.toExternalForm();
            Properties properties = DevicePropertyManager.getPropertiesResource(null, string2);
            properties.setProperty(DEVICE_NAME, string);
            properties.setProperty(DEVICE_FILE, file.toString());
            this.devicePropertyMap.put(string, properties);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)iOException, (Throwable)iOException);
            throw new IOException(ToolkitResources.format("DEVICE.NOTFOUND", new Object[]{string, file}));
        }
    }

    public Properties getDeviceProperties(String string) throws IOException {
        return (Properties)this.getDevicePropertiesImp(string).clone();
    }

    private static String formatProperty(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block3;
                }
                default: {
                    if (c >= '\u007f') {
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c);
                        for (int j = string2.length(); j < 4; ++j) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        continue block3;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readFile(File file, String string) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            object = arrayList;
            return object;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, String string, List list) throws IOException {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            printWriter = new PrintWriter(outputStreamWriter);
            for (String string2 : list) {
                printWriter.println(string2);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static int findPropertyIndex(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            StringTokenizer stringTokenizer;
            String string2 = ((String)list.get(i)).trim();
            if (string2.startsWith("#") || (stringTokenizer = new StringTokenizer(string2, "#:")).countTokens() == 0) continue;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals(string)) {
                return i;
            }
            while (string2.endsWith("\\") && i < list.size()) {
                string2 = ((String)list.get(++i)).trim();
            }
        }
        return -1;
    }

    public static URL getResource(Properties properties, String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (properties != null) {
                try {
                    String string2 = properties.getProperty(DEVICE_PATH);
                    File file = new File(string);
                    if (string2 == null || file.isAbsolute()) {
                        return file.toURL();
                    }
                    return new URL(new URL(string2), string);
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            try {
                return new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException3) {
                return null;
            }
        }
    }

    public static File getResourceFile(Properties properties, String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        if (properties == null) {
            return file;
        }
        String string2 = properties.getProperty(DEVICE_FILE);
        File file2 = new File(string2).getParentFile();
        return new File(file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesResource(Properties properties, String string) throws IOException {
        LOGGER.debug((Object)("Reading device properties from resource '" + string + '\''));
        URL uRL = DevicePropertyManager.getResource(properties, string);
        LOGGER.debug((Object)("Using URL: '" + uRL + '\''));
        File file = DevicePropertyManager.getResourceFile(properties, string);
        LOGGER.debug((Object)("Using file: '" + file + '\''));
        InclusionInputStream inclusionInputStream = new InclusionInputStream(uRL);
        try {
            Properties properties2 = new Properties();
            properties2.load(inclusionInputStream);
            properties2.setProperty(DEVICE_PATH, uRL.toExternalForm());
            properties2.setProperty(DEVICE_FILE, file.toString());
            LOGGER.debug((Object)"Properties loaded");
            Properties properties3 = properties2;
            return properties3;
        }
        finally {
            inclusionInputStream.close();
        }
    }

    private static class InclusionInputStream
    extends InputStream {
        private InputStream inclusionStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InclusionInputStream(URL uRL) throws IOException {
            BufferedReader bufferedReader = null;
            try {
                LOGGER.debug((Object)"Opening stream");
                InputStream inputStream = uRL.openStream();
                LOGGER.debug((Object)"Stream opened");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                boolean bl = false;
                while (!bl) {
                    String string;
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        bl = true;
                        continue;
                    }
                    boolean bl2 = false;
                    if (string2.startsWith("include") && (string = string2.substring("include".length())).length() > 0 && Character.isWhitespace(string.charAt(0))) {
                        string = string.trim();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                        while (stringTokenizer.hasMoreTokens()) {
                            URL uRL2 = new URL(uRL, stringTokenizer.nextToken());
                            InclusionInputStream inclusionInputStream = null;
                            try {
                                int n;
                                inclusionInputStream = new InclusionInputStream(uRL2);
                                byte[] byArray = new byte[4096];
                                while ((n = inclusionInputStream.read(byArray)) != -1) {
                                    printStream.write(byArray, 0, n);
                                }
                            }
                            finally {
                                if (inclusionInputStream == null) continue;
                                try {
                                    inclusionInputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (!bl2) {
                        printStream.println(string2);
                    }
                    printStream.flush();
                }
                this.inclusionStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                throw new IOException("Error reading " + uRL + " :\n  " + iOException.getMessage());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public int read() throws IOException {
            return this.inclusionStream.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.inclusionStream.read(byArray, n, n2);
        }
    }
}

