/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.sensor.api.ConnectionType;
import com.sun.kvem.sensor.api.ContextType;
import com.sun.kvem.sensor.api.GuiSensorProxy;
import com.sun.kvem.sensor.api.Sensor;
import com.sun.kvem.sensor.api.SensorDataWriter;
import com.sun.kvem.sensor.impl.DefaultGuiChannelProxy;
import com.sun.kvem.sensor.impl.DefaultSensorDataWriter;
import com.sun.kvem.sensor.model.Data;
import com.sun.kvem.sensor.model.SensorModel;
import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.TimeoutException;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class SunSpotSensorProxy
implements GuiSensorProxy {
    private static final Logger LOGGER = Logger.getLogger(SunSpotSensorProxy.class);
    private static final String SERIAL_PORT = "SERIAL_PORT";
    private static final int DEFAULT_UNSUCCESSFULL_TRY = 100;
    private boolean enabled;
    private long datagramReceiveTimeout;
    private String possibleBasestationPort;
    private String spotAddress;
    private int datagramPort;
    private int unsuccessfullTry = 100;
    private List<DefaultGuiChannelProxy> channelProxies = new ArrayList<DefaultGuiChannelProxy>();
    private final transient SensorModel sensor = new SensorModel();
    private final transient SpotControlls spotControlls = new SpotControlls();
    private final transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private transient SunSpotCommunicator sunSpotCommunicator;
    private transient ExecutorService singleThreadExecutor;
    private volatile boolean initBasestationDone;
    protected volatile boolean sensorInitialized;
    private AtomicBoolean sensorAvailable = new AtomicBoolean();
    protected volatile double channelRawDataX;
    protected volatile double channelRawDataY;
    protected volatile double channelRawDataZ;
    private transient CountDownLatch sensorAvailableLatch = new CountDownLatch(1);

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setDatagramReceiveTimeout(long l) {
        this.datagramReceiveTimeout = l;
    }

    public void setPossibleBasestationPort(String string) {
        this.possibleBasestationPort = string;
    }

    public void setSpotAddress(String string) {
        this.spotAddress = string;
    }

    public void setDatagramPort(int n) {
        this.datagramPort = n;
    }

    public void setBasestationRetry(int n) {
        this.unsuccessfullTry = n;
    }

    public void create() {
        for (int i = 0; i < this.channelProxies.size(); ++i) {
            this.sensor.addChannel(this.channelProxies.get(i).getChannelInfo());
        }
    }

    public void start() {
        this.sunSpotCommunicator = new SunSpotCommunicator();
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        if (!this.enabled) {
            LOGGER.warn((Object)"SunSPOT proxy disabled");
        } else {
            this.singleThreadExecutor.execute(this.sunSpotCommunicator);
        }
    }

    public void stop() {
        this.singleThreadExecutor.shutdownNow();
        this.singleThreadExecutor = null;
        this.sunSpotCommunicator = null;
    }

    public boolean init() {
        this.initBasestation();
        if (this.initBasestationDone) {
            boolean bl;
            try {
                this.sensorAvailableLatch.await();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            this.sensorInitialized = bl = this.sensorAvailable.get();
            return bl;
        }
        this.sensorInitialized = false;
        return false;
    }

    public synchronized boolean finish() {
        this.sensorInitialized = false;
        return true;
    }

    public Data measureData(int n) {
        double d;
        switch (n) {
            case 0: {
                d = this.channelRawDataX;
                break;
            }
            case 1: {
                d = this.channelRawDataY;
                break;
            }
            case 2: {
                d = this.channelRawDataZ;
                break;
            }
            default: {
                return null;
            }
        }
        return new Data((Object)d, 0.05f, true);
    }

    public Sensor getSensorInfo() {
        return this.sensor;
    }

    public void setDescription(String string) {
        this.sensor.setDescription(string);
    }

    public void setQuantity(String string) {
        this.sensor.setQuantity(string);
    }

    public void setContext(String string) {
        this.sensor.setContextType(ContextType.getByString((String)string));
    }

    public void setConnection(String string) {
        this.sensor.setConnType(ConnectionType.getByString((String)string));
    }

    public void setModel(String string) {
        this.sensor.setModel(string);
    }

    public void setMaxBuffer(int n) {
        this.sensor.setMaxBufSize(n);
    }

    public void addChannel(DefaultGuiChannelProxy defaultGuiChannelProxy) {
        this.channelProxies.add(defaultGuiChannelProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initBasestation() {
        if (!this.enabled) {
            return false;
        }
        SunSpotCommunicator sunSpotCommunicator = this.sunSpotCommunicator;
        synchronized (sunSpotCommunicator) {
            String string = this.possibleBasestationPort;
            this.spotControlls.log("\nLooking up Basestation at: " + string + "\nUsing SPOT address: " + this.spotAddress + "\nTo change default walues, edit " + "\ntoolkit-lib/emulator/generic/core/SensorProxyServer/SunSpotSensorProxy.bean");
            SunSpotSensorProxy sunSpotSensorProxy = this;
            synchronized (sunSpotSensorProxy) {
                if (this.initBasestationDone) {
                    this.spotControlls.log("BaseStation already initialized!");
                    return true;
                }
            }
            try {
                if (!string.startsWith("COM")) {
                    this.spotControlls.log("Port must start with COM. Was: " + string);
                    return false;
                }
                this.spotControlls.log("Initializing BaseStation ...");
                System.setProperty(SERIAL_PORT, string);
                this.initBasestationDone = true;
                this.spotControlls.log("Base station initialized");
                return true;
            }
            catch (SpotFatalException spotFatalException) {
                LOGGER.error((Object)"Spot Fatal exception", (Throwable)spotFatalException);
                this.spotControlls.log("Initialization failed: " + spotFatalException.getMessage() + "\nSee device.log");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error((Object)"Illegal Argument", (Throwable)illegalArgumentException);
                this.spotControlls.log("Initialization failed: " + illegalArgumentException.getMessage() + "\nSee device.log");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSensorAvailable(boolean bl) {
        try {
            if (this.sensorAvailable.compareAndSet(!bl, bl)) {
                if (!bl) {
                    this.sensorInitialized = false;
                }
                this.pcs.firePropertyChange("available", !bl, bl);
                this.sensor.setAvailable(bl);
                this.spotControlls.log("Set sensor " + (bl ? "available." : "unavailable."));
            }
        }
        finally {
            this.sensorAvailableLatch.countDown();
        }
    }

    public JComponent getGuiControls() {
        return this.spotControlls;
    }

    public boolean isAvailableWritable() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public SensorDataWriter getSensorDataWriter() {
        return DefaultSensorDataWriter.getInstance();
    }

    class SpotControlls
    extends JPanel {
        private JTextArea logArea;
        private Action connectAction;

        public SpotControlls() {
            Font font = (Font)UIManager.getDefaults().get("TextArea.font");
            UIManager.getDefaults().put("TextArea.font", font.deriveFont(12.0f));
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.connectAction = new AbstractAction("Reconnect"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SunSpotSensorProxy.this.singleThreadExecutor.execute(SunSpotSensorProxy.this.sunSpotCommunicator);
                }
            };
            this.connectAction.setEnabled(false);
            this.logArea = new JTextArea();
            JButton jButton = new JButton(this.connectAction);
            this.add(new JScrollPane(this.logArea));
            this.add(Box.createVerticalStrut(4));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(jButton);
            this.add(jPanel);
        }

        void setReconnectEnabled(boolean bl) {
            this.connectAction.setEnabled(bl);
        }

        synchronized void log(String string) {
            this.logArea.append(string + "\n");
            LOGGER.info((Object)string);
        }
    }

    class SunSpotCommunicator
    implements Runnable {
        private static final long RECONNECT_TIMEOUT = 1000L;
        private final int port;
        private final String spotAddress;
        private int trys;

        public SunSpotCommunicator() {
            this.spotAddress = SunSpotSensorProxy.this.spotAddress;
            this.port = SunSpotSensorProxy.this.datagramPort;
            this.trys = 0;
        }

        @Override
        public void run() {
            SunSpotSensorProxy.this.spotControlls.setReconnectEnabled(false);
            try {
                while (this.trys < SunSpotSensorProxy.this.unsuccessfullTry) {
                    try {
                        if (!SunSpotSensorProxy.this.initBasestation()) {
                            ++this.trys;
                            Thread.sleep(1000L);
                            continue;
                        }
                        this.run(this.openConnection());
                    }
                    catch (IOException iOException) {
                        SunSpotSensorProxy.this.spotControlls.log("I/O Exception: \n" + iOException.getMessage());
                        ++this.trys;
                    }
                    catch (RuntimeException runtimeException) {
                        SunSpotSensorProxy.this.spotControlls.log("Exception: \n" + runtimeException.getMessage());
                        ++this.trys;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.info((Object)"Interrupted");
            }
            SunSpotSensorProxy.this.spotControlls.log("Stop.");
            SunSpotSensorProxy.this.spotControlls.setReconnectEnabled(true);
        }

        protected RadiogramConnection openConnection() throws IOException {
            LOGGER.info((Object)("Listening for datagrams on port " + this.port));
            RadiogramConnection radiogramConnection = (RadiogramConnection)Connector.open((String)("radiogram://:" + this.port));
            radiogramConnection.setTimeout(SunSpotSensorProxy.this.datagramReceiveTimeout);
            return radiogramConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(RadiogramConnection radiogramConnection) throws IOException {
            try {
                Datagram datagram = radiogramConnection.newDatagram(radiogramConnection.getMaximumLength());
                long l = System.currentTimeMillis();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        datagram.reset();
                        LOGGER.trace((Object)"Receiving a datagram from SunSPOT...");
                        radiogramConnection.receive(datagram);
                        if (this.process(datagram)) {
                            l = System.currentTimeMillis();
                            SunSpotSensorProxy.this.setSensorAvailable(true);
                            continue;
                        }
                        if (System.currentTimeMillis() - l <= SunSpotSensorProxy.this.datagramReceiveTimeout) continue;
                        SunSpotSensorProxy.this.setSensorAvailable(false);
                    }
                    catch (TimeoutException timeoutException) {
                        SunSpotSensorProxy.this.setSensorAvailable(false);
                    }
                }
            }
            finally {
                radiogramConnection.close();
            }
        }

        protected boolean process(Datagram datagram) throws IOException {
            LOGGER.trace((Object)"Processing a datagram from SunSPOT");
            if (!this.spotAddress.equals(datagram.getAddress())) {
                return false;
            }
            if (SunSpotSensorProxy.this.sensorInitialized) {
                SunSpotSensorProxy.this.channelRawDataX = datagram.readDouble();
                SunSpotSensorProxy.this.channelRawDataY = datagram.readDouble();
                SunSpotSensorProxy.this.channelRawDataZ = datagram.readDouble();
            }
            return true;
        }
    }
}

