/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bridge.connmanager;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.Version;
import com.sun.jme.remoting.VersionProvider;
import com.sun.jme.services.connmanager.ConnectionManagerService;
import com.sun.jme.services.connmanager.JmeConnectionException;
import com.sun.jme.toolkit.bridge.connmanager.ConnectionManagerAdapterMBean;
import com.sun.jme.toolkit.device.connmanager.api.ConnectionException;
import com.sun.jme.toolkit.remoting.bridge.JavameRemotingService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public final class ConnectionManagerAdapter
implements ConnectionManagerAdapterMBean {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManagerAdapter.class);
    private static final String LOCAL_ODT_VERSION_RESOURCE = "/com/sun/jme/services/odt-version";
    private static final String REMOTE_ODT_VERSION_OBJECT = "OdtVersion";
    private final JavameRemotingService jmeRemotingService;
    private final String jmeServiceName;
    private ConnectionManagerService connectionManagerJmeService;

    public ConnectionManagerAdapter(JavameRemotingService javameRemotingService, String string) {
        this.jmeRemotingService = javameRemotingService;
        this.jmeServiceName = string;
    }

    public void initializeConnection() throws ConnectionException {
        if (this.connectionManagerJmeService != null) {
            return;
        }
        try {
            this.connectionManagerJmeService = (ConnectionManagerService)this.jmeRemotingService.getRemoteObject(this.jmeServiceName, ConnectionManagerService.class);
        }
        catch (CommException commException) {
            throw new ConnectionException("Incompatible ODT agent!");
        }
        try {
            this.jmeRemotingService.versionCheck();
            Version version = ConnectionManagerAdapter.getLocalOdtVersion();
            Version version2 = this.getRemoteOdtVersion();
            if (!version.equals((Object)version2)) {
                throw new ConnectionException("ODT version check failed in jme remoting! Local version " + version + " isn't equal to remote version " + version2 + ".");
            }
            this.connectionManagerJmeService.initializeConnection();
        }
        catch (CommException commException) {
            throw new ConnectionException(commException.getMessage());
        }
        catch (JmeConnectionException jmeConnectionException) {
            throw new ConnectionException(jmeConnectionException.getMessage());
        }
    }

    public void checkConnection() throws ConnectionException {
        try {
            this.connectionManagerJmeService.checkConnection();
        }
        catch (CommException commException) {
            throw new ConnectionException(commException.getMessage());
        }
        catch (JmeConnectionException jmeConnectionException) {
            throw new ConnectionException(jmeConnectionException.getMessage());
        }
    }

    private Version getRemoteOdtVersion() throws CommException {
        VersionProvider versionProvider;
        try {
            this.jmeRemotingService.registerObjectStubClass(REMOTE_ODT_VERSION_OBJECT, VersionProvider.class);
            versionProvider = (VersionProvider)this.jmeRemotingService.getRemoteObject(REMOTE_ODT_VERSION_OBJECT, VersionProvider.class);
        }
        catch (CommException commException) {
            LOGGER.debug((Object)"Remote site doesn't provide OdtVersion!");
            return new Version();
        }
        return versionProvider.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Version getLocalOdtVersion() {
        InputStream inputStream = ConnectionManagerAdapter.class.getResourceAsStream(LOCAL_ODT_VERSION_RESOURCE);
        if (inputStream == null) {
            LOGGER.debug((Object)"There is no /com/sun/jme/services/odt-version!");
            return new Version();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            try {
                String string = bufferedReader.readLine();
                while (string != null && (string.length() == 0 || string.startsWith("#"))) {
                    string = bufferedReader.readLine();
                }
                if (string != null) {
                    Version version = new Version(string.trim());
                    return version;
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LOGGER.debug((Object)"Failed to get version from /com/sun/jme/services/odt-version!");
        return new Version();
    }
}

