/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.jme.emulator.events.GenericEventManager;
import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.kvem.cdc.EventBridgeMBean;
import java.awt.event.MouseEvent;
import java.util.concurrent.LinkedBlockingQueue;

public class EventBridge
extends GenericEventManager
implements EventManagerSpi,
EventBridgeMBean {
    private static final LinkedBlockingQueue<int[]> systemEventQueue = new LinkedBlockingQueue();
    static final int UI_EVENT_INVALID = -2;
    static final int UI_EVENT_STOP = -1;
    static final int UI_EVENT_KEY = 0;
    static final int UI_EVENT_MOUSE = 1;
    static final int UI_EVENT_MOUSEWHEEL = 2;
    static final int UI_EVENT_SYSTEM = 11;
    static final int UI_EVENT_MOUSE_BUTTON_PRESSED = 0;
    static final int UI_EVENT_MOUSE_BUTTON_RELEASED = 1;
    static final int UI_EVENT_MOUSE_MOVED = 2;
    static final int UI_EVENT_KEY_PRESSED = 3;
    static final int UI_EVENT_KEY_RELEASED = 4;
    static final int UI_EVENT_KEY_REPEATED = 23;
    static final int UI_EVENT_DEVICEKEY_PRESSED = 7;
    static final int UI_EVENT_DEVICEKEY_RELEASED = 8;
    static final int UI_EVENT_DEVICEKEY_REPEATED = 27;
    static final int UI_MOUSE_BUTTON_LEFT = 0;
    static final int UI_MOUSE_BUTTON_MIDDLE = 1;
    static final int UI_MOUSE_BUTTON_RIGHT = 2;
    static final int SHUTDOWN = 3;
    static final int JCOV = 4;
    private int[] lastPenMoveEvent;
    private boolean optimizePenMoves;
    private static EventBridge instance;

    public void setOptimizePenMoves(boolean bl) {
        this.optimizePenMoves = bl;
    }

    public EventBridge() {
        instance = this;
    }

    public static void initialize() {
    }

    public void penDown(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse click at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, mouseEvent, 0);
    }

    public void penUp(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse release at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, mouseEvent, 1);
    }

    public void penMove(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse move at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, mouseEvent, 2);
    }

    private void injectMouseEvent(int n, int n2, MouseEvent mouseEvent, int n3) {
        int[] nArray = new int[]{1, n3, EventBridge.internalMouseEventCode(mouseEvent), mouseEvent.getID(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), n, n2};
        if (2 == n3) {
            if (this.optimizePenMoves && this.lastPenMoveEvent != null && this.lastPenMoveEvent[0] == 1 && this.lastPenMoveEvent[1] == 2 && this.lastPenMoveEvent[2] == EventBridge.internalMouseEventCode(mouseEvent) && this.lastPenMoveEvent[3] == mouseEvent.getID() && this.lastPenMoveEvent[4] == (mouseEvent.getModifiers() | mouseEvent.getModifiersEx())) {
                this.deleteEvent(this.lastPenMoveEvent);
            }
            this.lastPenMoveEvent = nArray;
        }
        this.queueEvent(nArray);
    }

    private static int internalMouseEventCode(MouseEvent mouseEvent) {
        int n;
        switch (mouseEvent.getButton()) {
            default: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
            }
        }
        return n;
    }

    public void injectKeyPressedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(bl ? 7 : 3, n, n2, n3, n4);
    }

    public void injectKeyRepeatedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(bl ? 27 : 23, n, n2, n3, n4);
    }

    public void injectKeyReleasedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(bl ? 8 : 4, n, n2, n3, n4);
    }

    private void injectKeyEvent(int n, int n2, int n3, int n4, int n5) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("injectKeyEvent minor:" + n + " keyCode:" + n2 + " keyChar:" + n3 + " id:" + n4 + " modifiers:" + n5));
        }
        instance.queueEvent(new int[]{0, n, n2, n3, n4, n5});
    }

    public void injectShutdownEvent() {
        LOGGER.debug((Object)"Injecting SHUTDOWN event");
        this.injectSystemEvent(3);
    }

    public void injectSwitchStateEvent(int n) {
        throw new UnsupportedOperationException("injectSwitchStateEvent");
    }

    public void injectRotateEvent(int n) {
        throw new UnsupportedOperationException("injectRotateEvent");
    }

    public void injectSystemEvent(int n) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("injectSystemEvent " + n));
        }
        instance.queueEvent(new int[]{11, n, 0, 0, 0, 0});
    }

    public static int[] getEvent(boolean bl, long l) {
        return instance.takeEvent(bl, l);
    }

    public void injectResumeEvent() {
    }

    public void injectJcovEvent() {
        EventBridge.injectSystemQueueEvent(new int[]{4});
    }

    public static void injectSystemQueueEvent(int[] nArray) {
        try {
            systemEventQueue.put(nArray);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn((Object)interruptedException, (Throwable)interruptedException);
            throw (RuntimeException)new RuntimeException().initCause(interruptedException);
        }
    }

    public static int[] getSystemEvent() {
        try {
            return systemEventQueue.take();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn((Object)interruptedException, (Throwable)interruptedException);
            return null;
        }
    }
}

