/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.isshutdown;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public final class InputStreamShutdown
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(InputStreamShutdown.class);
    private CountDownLatch shutdownTriggerLatch;
    private InputStream inputStream;
    private PrintStream printStream;
    private String notificationMessage;

    public void start() {
        new Thread(this).start();
    }

    public void setShutdownTriggerLatch(CountDownLatch countDownLatch) {
        this.shutdownTriggerLatch = countDownLatch;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public void setNotificationMessage(String string) {
        this.notificationMessage = string;
    }

    @Override
    public void run() {
        try {
            int n;
            while ((n = System.in.available()) > 0) {
                System.in.skip(n);
            }
            if (this.printStream != null) {
                this.printStream.println(this.notificationMessage);
            }
            if (System.in.read() == -1) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        LOGGER.debug((Object)"Shutting down.");
        this.shutdownTriggerLatch.countDown();
    }
}

