/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bridge.midletmanager;

import com.sun.jme.remoting.CommException;
import com.sun.jme.services.appmanager.AppManagerService;
import com.sun.jme.services.appmanager.AppManagerServiceException;
import com.sun.jme.services.appmanager.AppStateObserver;
import com.sun.jme.services.appmanager.InstallServiceException;
import com.sun.jme.toolkit.bridge.midletmanager.AppManagerAdapterMBean;
import com.sun.jme.toolkit.bridge.midletmanager.WrapperAppManagerException;
import com.sun.jme.toolkit.bridge.midletmanager.WrapperInstallException;
import com.sun.jme.toolkit.device.appmanager.AppManagerException;
import com.sun.jme.toolkit.device.appmanager.InstallException;
import com.sun.jme.toolkit.device.appmanager.api.AppEventListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AppManagerAdapter
implements AppManagerAdapterMBean,
AppStateObserver {
    private static final Logger LOGGER = Logger.getLogger(AppManagerAdapter.class);
    private final AppManagerService appManagerJmeService;
    private List<AppEventListener> listeners = new ArrayList<AppEventListener>();

    public AppManagerAdapter(AppManagerService appManagerService) {
        this.appManagerJmeService = appManagerService;
    }

    public final int installMIDletSuite(String string, boolean bl) throws InstallException, AppManagerException {
        try {
            this.installingMidlet(string);
            int n = this.appManagerJmeService.installMIDletSuite(string, bl);
            this.midletInstalled(string, n);
            return n;
        }
        catch (InstallServiceException installServiceException) {
            throw new WrapperInstallException(installServiceException);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void runMIDletSuite(String string, String string2, int n) throws AppManagerException {
        try {
            this.appManagerJmeService.runMIDletSuite(string, string2, n);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void runMIDletSuite(int n, String string, int n2) throws AppManagerException {
        try {
            this.appManagerJmeService.runMIDletSuite(n, string, n2);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void stopMIDletSuite(String string, String string2) throws AppManagerException {
        try {
            this.appManagerJmeService.stopMIDletSuite(string, string2);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public void stopMIDletSuite(int n, String string) throws AppManagerException {
        try {
            this.appManagerJmeService.stopMIDletSuite(n, string);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void removeMIDletSuite(String string) throws AppManagerException {
        try {
            this.appManagerJmeService.removeMIDletSuite(string);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void removeMIDletSuite(int n) throws AppManagerException {
        try {
            this.removingMidlet(n);
            this.appManagerJmeService.removeMIDletSuite(n);
            this.midletRemoved(n);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final int executeMIDletSuite(String string, boolean bl, String string2, int n) throws InstallException, AppManagerException {
        try {
            this.installingMidlet(string);
            this.appManagerJmeService.addAppStateObserver((AppStateObserver)this);
            int n2 = this.appManagerJmeService.executeMIDletSuite(string, bl, string2, n);
            this.midletInstalled(string, n2);
            return n2;
        }
        catch (InstallServiceException installServiceException) {
            throw new WrapperInstallException(installServiceException);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final String[] getInstalledAppList() throws AppManagerException {
        try {
            return this.appManagerJmeService.getInstalledAppList();
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final String[] getStorageNames() throws AppManagerException {
        try {
            return this.appManagerJmeService.getStorageNames();
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final int[] getStorageIds() throws AppManagerException {
        try {
            return this.appManagerJmeService.getStorageIds();
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void launchAutotester(String string, String string2) throws InstallException, AppManagerException {
        try {
            this.appManagerJmeService.launchAutotester(string, string2);
        }
        catch (InstallServiceException installServiceException) {
            throw new WrapperInstallException(installServiceException);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final int getAppState(int n) throws AppManagerException {
        try {
            return this.appManagerJmeService.getAppState(n);
        }
        catch (AppManagerServiceException appManagerServiceException) {
            throw new WrapperAppManagerException(appManagerServiceException);
        }
        catch (CommException commException) {
            throw new RuntimeException(commException.getMessage());
        }
    }

    public final void handleAppEvent(int n, int n2) throws CommException {
        this.midletRemoved(n);
        for (AppEventListener appEventListener : this.listeners) {
            LOGGER.debug((Object)("Going to invoke handleAppEvent on listener " + appEventListener));
            appEventListener.handleAppEvent(n, n2);
            LOGGER.debug((Object)("Invoke handleAppEvent on listener " + appEventListener));
        }
    }

    public final void addAppEventListener(AppEventListener appEventListener) {
        this.listeners.add(appEventListener);
    }

    public final void removeAppEventListener(AppEventListener appEventListener) {
        this.listeners.remove(appEventListener);
    }

    protected void installingMidlet(String string) {
    }

    protected void midletInstalled(String string, int n) {
    }

    protected void removingMidlet(int n) {
    }

    protected void midletRemoved(int n) {
    }

    protected void removingMidlet(String string) {
    }

    protected void midletRemoved(String string) {
    }
}

