/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.vm;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.jme.toolkit.util.process.AbstractProcessRunner;
import com.sun.jme.toolkit.vm.KVMDeviceInterface;
import com.sun.jme.toolkit.vm.ProcessLauncher;
import com.sun.kvem.Lime;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class Launcher
implements ProcessLauncher {
    private static final Logger LOGGER = Logger.getLogger(Launcher.class);
    private static final int TIMEOUT = 3000;
    private CountDownLatch shutdownLatch;
    private AtomicInteger returnCode;
    private File executable;
    private String workingDirectory;
    private Lime lime;
    private KVMDeviceInterface deviceInterface;
    private EventManagerSpi eventManager;
    private transient Thread thread;
    private transient List<String> argList = new ArrayList<String>();
    private transient AbstractProcessRunner runner;

    public void setReturnCode(AtomicInteger atomicInteger) {
        this.returnCode = atomicInteger;
    }

    public void setLime(Lime lime) {
        this.lime = lime;
    }

    public void setDeviceInterface(KVMDeviceInterface kVMDeviceInterface) {
        this.deviceInterface = kVMDeviceInterface;
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void setShutdownLatch(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    @Override
    public OutputStream getOutputStream() throws InterruptedException {
        return null;
    }

    @Override
    public void appendArgument(String string) {
        this.argList.add(string);
    }

    @Override
    public void prependArgument(String string) {
        this.argList.add(0, string);
    }

    @Override
    public void appendArguments(Collection<String> collection) {
        this.argList.addAll(collection);
    }

    @Override
    public void prependArguments(Collection<String> collection) {
        this.argList.addAll(0, collection);
    }

    public void start() throws IOException {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.debug((Object)("Running the VM, argv = " + Launcher.this.argList));
                LOGGER.debug((Object)("Using executable: " + Launcher.this.executable));
                int n = this.runKVM(Launcher.this.executable.getAbsolutePath(), Launcher.this.argList.toArray(new String[Launcher.this.argList.size()]), null, Launcher.this.workingDirectory);
                LOGGER.debug((Object)("VM returned " + n));
                Launcher.this.returnCode.set(n);
                Launcher.this.shutdownLatch.countDown();
            }

            int runKVM(final String string, final String[] stringArray, final String[] stringArray2, String string2) {
                try {
                    final File file = new File(string2);
                    file.mkdirs();
                    Launcher.this.runner = new AbstractProcessRunner(){
                        private Logger vmLogger = Logger.getLogger((String)"VM");

                        protected Process startProcess() throws IOException {
                            return Launcher.this.lime.runClient(string, stringArray, stringArray2, file);
                        }

                        protected void handleOutput(String string2) {
                            this.vmLogger.info((Object)string2);
                        }
                    };
                    Launcher.this.runner.start();
                    return Launcher.this.runner.getExitValue();
                }
                catch (Exception exception) {
                    System.err.println("Error running executable " + string);
                    exception.printStackTrace();
                    return 1;
                }
            }
        });
        this.thread.setName("VM Executor");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Launcher launcher = this;
        synchronized (launcher) {
            this.eventManager.injectShutdownEvent();
            try {
                if (!this.runner.waitForProcessTerminated(3000) && this.runner != null) {
                    LOGGER.debug((Object)"Destroying VM process");
                    this.runner.stop();
                    this.runner = null;
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn((Object)interruptedException, (Throwable)interruptedException);
            }
            Launcher launcher2 = this;
            synchronized (launcher2) {
                if (this.lime != null) {
                    LOGGER.debug((Object)"Disconnecting Lime");
                    this.lime.disconnect();
                    Object object = this.lime.getLock();
                    synchronized (object) {
                        if (this.deviceInterface != null) {
                            this.deviceInterface.finalizeWindowSystem();
                        }
                    }
                    this.lime = null;
                }
            }
        }
        this.thread.interrupt();
        this.thread = null;
    }
}

