/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ui.actions;

import com.sun.jme.toolkit.ui.util.LocalizedAction;
import com.sun.kvem.midp.EventBridge;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LocaleAction
extends LocalizedAction {
    private JFrame frame;
    private EventBridge eventBridge;
    private static final String LOCALE_CHANGE_MSG1 = "LOCALE_CHANGE_MSG1";
    private static final String LOCALE_CHANGE_MSG2 = "LOCALE_CHANGE_MSG2";
    private static final String LOCALE_CHANGE_TITLE = "LOCALE_CHANGE_TITLE";

    public void actionPerformed(ActionEvent actionEvent) {
        LocaleDialog localeDialog = new LocaleDialog((Frame)this.frame, true);
        localeDialog.setVisible(true);
        String string = localeDialog.getLanguageCode();
        String string2 = localeDialog.getRegionalCode();
        if (string != null) {
            this.eventBridge.localeChanged(string, string2);
        }
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void setEventBridge(EventBridge eventBridge) {
        this.eventBridge = eventBridge;
    }

    private static class LocaleDialog
    extends JDialog {
        private String languageCode;
        private String regionalCode;
        private Pattern localePattern = Pattern.compile("([a-z]{2})(?:[_-]([A-Z]{2}))?");
        private JPanel buttonPanel;
        private JButton cancelButton;
        private JTextField localeField;
        private JLabel msgLabel1;
        private JLabel msgLabel2;
        private JButton okButton;

        public LocaleDialog(Frame frame, boolean bl) {
            super(frame, bl);
            this.initComponents();
            this.checkValidity();
            this.setLocationRelativeTo(frame);
        }

        public String getRegionalCode() {
            return this.regionalCode;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        private void checkValidity() {
            this.okButton.setEnabled(this.localePattern.matcher(this.localeField.getText()).matches());
        }

        private void initComponents() {
            this.msgLabel1 = new JLabel();
            this.localeField = new JTextField();
            this.buttonPanel = new JPanel();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
            this.msgLabel2 = new JLabel();
            this.setDefaultCloseOperation(2);
            this.setTitle(ToolkitResources.getString((String)LocaleAction.LOCALE_CHANGE_TITLE));
            this.getContentPane().setLayout(new GridBagLayout());
            this.msgLabel1.setText(ToolkitResources.getString((String)LocaleAction.LOCALE_CHANGE_MSG1));
            this.msgLabel2.setText(ToolkitResources.getString((String)LocaleAction.LOCALE_CHANGE_MSG2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 5, 0, 5);
            this.getContentPane().add((Component)this.msgLabel1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.getContentPane().add((Component)this.msgLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 4, 5);
            this.getContentPane().add((Component)this.localeField, gridBagConstraints);
            this.localeField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (this.getLength() + string.length() > 5) {
                        return;
                    }
                    super.insertString(n, string, attributeSet);
                }
            });
            this.localeField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    LocaleDialog.this.checkValidity();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    LocaleDialog.this.checkValidity();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    LocaleDialog.this.checkValidity();
                }
            });
            this.localeField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        LocaleDialog.this.okButton.doClick();
                    } else if (keyEvent.getKeyCode() == 27) {
                        LocaleDialog.this.cancelButton.doClick();
                    }
                }
            });
            this.buttonPanel.setLayout(new FlowLayout(0));
            this.okButton.setText(ToolkitResources.getString((String)"OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Matcher matcher = LocaleDialog.this.localePattern.matcher(LocaleDialog.this.localeField.getText());
                    matcher.matches();
                    LocaleDialog.this.languageCode = matcher.group(1);
                    LocaleDialog.this.regionalCode = matcher.group(2);
                    LocaleDialog.this.dispose();
                }
            });
            this.buttonPanel.add(this.okButton);
            this.cancelButton.setText(ToolkitResources.getString((String)"Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LocaleDialog.this.dispose();
                }
            });
            this.buttonPanel.add(this.cancelButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
            this.pack();
        }
    }
}

