/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.AddressInfo;
import com.sun.kvem.location.QualifiedCoordinates;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Landmark {
    private String[] categories = new String[0];
    private int recordId = -1;
    private String storeName = null;
    private String name;
    private String description;
    private QualifiedCoordinates coordinates;
    private AddressInfo addressInfo;

    public Landmark(String string, String string2, QualifiedCoordinates qualifiedCoordinates, AddressInfo addressInfo) {
        this.setName(string);
        this.description = string2;
        this.coordinates = qualifiedCoordinates;
        this.addressInfo = addressInfo;
    }

    public Landmark(Landmark landmark) {
        this(landmark.serialize());
    }

    public Landmark(byte[] byArray) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            if (dataInputStream.readBoolean()) {
                String[] stringArray = new String[17];
                for (n = 0; n < 17; ++n) {
                    if (!dataInputStream.readBoolean()) continue;
                    stringArray[n] = dataInputStream.readUTF();
                }
                this.addressInfo = new AddressInfo(stringArray);
            }
            if (dataInputStream.readBoolean()) {
                float f = dataInputStream.readFloat();
                float f2 = dataInputStream.readFloat();
                float f3 = dataInputStream.readFloat();
                double d = dataInputStream.readDouble();
                double d2 = dataInputStream.readDouble();
                this.coordinates = new QualifiedCoordinates(d2, d, f3, f2, f);
            }
            if (dataInputStream.readBoolean()) {
                this.description = dataInputStream.readUTF();
            }
            if (dataInputStream.readBoolean()) {
                this.name = dataInputStream.readUTF();
            }
            int n2 = dataInputStream.readInt();
            this.categories = new String[n2];
            for (n = 0; n < n2; ++n) {
                if (!dataInputStream.readBoolean()) continue;
                this.categories[n] = dataInputStream.readUTF();
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] serialize() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (this.getAddressInfo() != null) {
                String[] stringArray = this.getAddressInfo().getData();
                dataOutputStream.writeBoolean(true);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) {
                        dataOutputStream.writeBoolean(false);
                        continue;
                    }
                    dataOutputStream.writeBoolean(true);
                    dataOutputStream.writeUTF(stringArray[i]);
                }
            } else {
                dataOutputStream.writeBoolean(false);
            }
            if (this.coordinates == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeFloat(this.coordinates.getVerticalAccuracy());
                dataOutputStream.writeFloat(this.coordinates.getHorizontalAccuracy());
                dataOutputStream.writeFloat(this.coordinates.getAltitude());
                dataOutputStream.writeDouble(this.coordinates.getLongitude());
                dataOutputStream.writeDouble(this.coordinates.getLatitude());
            }
            this.writePossiblyNull(dataOutputStream, this.description);
            this.writePossiblyNull(dataOutputStream, this.name);
            dataOutputStream.writeInt(this.categories.length);
            for (int i = 0; i < this.categories.length; ++i) {
                this.writePossiblyNull(dataOutputStream, this.categories[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void writePossiblyNull(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(string);
        }
    }

    public int getRecordId() {
        return this.recordId;
    }

    public void setRecordId(int n) {
        this.recordId = n;
    }

    String getStoreName() {
        return this.storeName;
    }

    void setStoreName(String string) {
        this.storeName = string;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] stringArray) {
        this.categories = stringArray;
    }

    public void addCategory(String string) {
        String[] stringArray = new String[this.categories.length + 1];
        System.arraycopy(this.categories, 0, stringArray, 0, this.categories.length);
        this.categories = stringArray;
        stringArray[stringArray.length - 1] = string;
    }

    public void removeCategory(String string) {
        if (string == null) {
            string = "";
        }
        if (this.categories == null || this.categories.length == 0) {
            return;
        }
        String[] stringArray = new String[this.categories.length - 1];
        int n = 0;
        for (int i = 0; i < this.categories.length; ++i) {
            if (string.equals(this.categories[i])) continue;
            if (n == stringArray.length) {
                return;
            }
            stringArray[n] = this.categories[i];
            ++n;
        }
        this.categories = stringArray;
    }

    public boolean isInCategory(String string) {
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (!string.equals(this.categories[i])) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public QualifiedCoordinates getQualifiedCoordinates() {
        return this.coordinates;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setQualifiedCoordinates(QualifiedCoordinates qualifiedCoordinates) {
        this.coordinates = qualifiedCoordinates;
    }

    public void setAddressInfo(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.categories.length; ++i) {
            stringBuffer.append(this.categories[i]);
            stringBuffer.append(";");
        }
        String string = "" + this.addressInfo;
        String string2 = this.coordinates != null ? "Lat: " + this.coordinates.getLatitude() + " Lon: " + this.coordinates.getLongitude() : "null";
        String string3 = "" + this.name;
        String string4 = "" + this.description;
        return "Landmark: { storeName = " + this.storeName + " recordId = " + this.recordId + " name = " + string3 + "  description = " + string4 + " coordinates = " + string2 + " addressInfo = " + string + " categories = " + stringBuffer.toString() + " }";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Landmark)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Landmark landmark = (Landmark)object;
        boolean bl = this.recordId == landmark.recordId;
        boolean bl2 = this.storeName == landmark.storeName || this.storeName != null && this.storeName.equals(landmark.storeName);
        return bl && bl2;
    }
}

