/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.Landmark;
import com.sun.kvem.location.LocationBridge;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LandmarkDB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LandmarkDB.class);
    private String name;
    private Vector<byte[]> landmarks;
    private Vector<String> categories = new Vector();

    LandmarkDB(String string) {
        this.name = string;
        this.landmarks = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public int addLandmark(byte[] byArray) {
        this.landmarks.addElement(byArray);
        return this.landmarks.size() - 1;
    }

    public void deleteLandmark(int n) {
        this.landmarks.setElementAt(null, n);
    }

    public Enumeration<byte[]> getLandmarks() {
        return this.landmarks.elements();
    }

    public Landmark getLandmark(int n) {
        Iterator<byte[]> iterator = this.landmarks.iterator();
        int n2 = -1;
        int n3 = -1;
        byte[] byArray = null;
        while (n2 < n) {
            ++n3;
            byArray = iterator.next();
            if (byArray == null) continue;
            ++n2;
        }
        Landmark landmark = new Landmark(byArray);
        landmark.setRecordId(n3);
        return landmark;
    }

    public int getLandmarkCount() {
        Iterator<byte[]> iterator = this.landmarks.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            ++n;
        }
        return n;
    }

    public void writeStore(File file) {
        if (file == null) {
            file = new File(LocationBridge.getWorkDir(), this.name + ".lms");
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            logger.info((Object)"", (Throwable)iOException);
        }
    }

    public void writeStore() {
        this.writeStore(null);
    }

    public void updateLandmark(int n, byte[] byArray) {
        this.landmarks.setElementAt(byArray, n);
    }

    int getCategoryPosition(String string) {
        return this.categories.indexOf(string);
    }

    public void addCategory(String string) {
        if (this.categories.contains(string)) {
            return;
        }
        this.categories.addElement(string);
    }

    public void deleteCategory(String string) {
        this.categories.removeElement(string);
    }

    public Vector<String> getCategories() {
        return this.categories;
    }

    public byte[] getSerializedLandmarks() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Serializing %d landmarks", this.landmarks.size()));
            }
            for (int i = 0; i < this.landmarks.size(); ++i) {
                byte[] byArray = this.landmarks.elementAt(i);
                if (byArray == null) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Landmark id: %d, length: %d", i, this.landmarks.size()));
                }
                dataOutputStream.writeInt(i);
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Serialized landmarks size: %d", byArray.length));
            }
            return byArray;
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }
}

