/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.LandmarkDB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public final class LocationBridge {
    private static final Logger logger = Logger.getLogger(LocationBridge.class);
    private static final String DEFAULT_STORE = "_default";
    private static final String DEFAULT_STORE_PATH = "default";
    public static final String LMS_EXT = ".lms";
    private static Hashtable landmarkStores;
    private static LandmarkDB defaultStore;
    private static LocationBridge instance;
    private static File workDirectory;

    public static void setWorkDirectory(File file) {
        workDirectory = file;
    }

    private static File getDefaultStoreFile() {
        return new File(LocationBridge.getWorkDir(), DEFAULT_STORE_PATH + File.separator + DEFAULT_STORE + LMS_EXT);
    }

    static File getWorkDir() {
        return workDirectory;
    }

    public LocationBridge() {
        instance = this;
    }

    public static LocationBridge getInstance() {
        return instance;
    }

    public static String listStoreNames() {
        Enumeration enumeration = LocationBridge.getLandmarkStores().keys();
        logger.fatal((Object)("LandmarkStore names " + enumeration));
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(';');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        logger.info((Object)("Landmark stores: " + stringBuffer));
        return stringBuffer.toString();
    }

    private static Hashtable getLandmarkStores() {
        if (landmarkStores == null) {
            landmarkStores = LocationBridge.initStores();
        }
        return landmarkStores;
    }

    private static LandmarkDB getDefaultStore() {
        if (defaultStore == null) {
            defaultStore = LocationBridge.initDefaultStore();
        }
        return defaultStore;
    }

    public static boolean storeExists(String string) {
        return LocationBridge.getLandmarkStores().keySet().contains(string);
    }

    public static void addStoreName(String string) {
        logger.info((Object)("Create Landmark store: " + string));
        LandmarkDB landmarkDB = new LandmarkDB(string);
        LocationBridge.getLandmarkStores().put(string, landmarkDB);
        LocationBridge.saveStores();
    }

    public static void removeStoreName(String string) {
        logger.info((Object)("Delete Landmark store: " + string));
        LocationBridge.getLandmarkStores().remove(string);
        new File(LocationBridge.getWorkDir(), string + LMS_EXT).delete();
    }

    public static String getCategoriesForStore(String string) {
        logger.info((Object)("Get categories from store: " + string));
        StringBuffer stringBuffer = new StringBuffer();
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        logger.info((Object)("LandmarkStore: " + landmarkDB));
        Enumeration<String> enumeration = landmarkDB.getCategories().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if ("".equals(string2)) continue;
            stringBuffer.append(string2);
            stringBuffer.append(";");
        }
        logger.info((Object)("Concatinated categories: " + stringBuffer.toString()));
        if (stringBuffer.length() == 0) {
            return "";
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static int addLandmarkToStore(byte[] byArray, String string) {
        logger.info((Object)("Adding landmark to " + string));
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        int n = landmarkDB.addLandmark(byArray);
        LocationBridge.saveStores();
        return n;
    }

    public static void deleteLandmarkFromStore(int n, String string) {
        logger.info((Object)("deleting landmark " + n + " from " + string));
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        landmarkDB.deleteLandmark(n);
        LocationBridge.saveStores();
    }

    public static void updateLandmarkInStore(String string, int n, byte[] byArray) {
        logger.info((Object)("Updating landmark id=" + n + " in " + string));
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        landmarkDB.updateLandmark(n, byArray);
        LocationBridge.saveStores();
    }

    public static byte[] getLandmarksFromStore(String string) {
        logger.info((Object)("Retrieving landmarks from " + string));
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        return landmarkDB.getSerializedLandmarks();
    }

    public static LandmarkDB getLandmarks(String string) {
        logger.info((Object)("Retrieving landmarks from " + string));
        LandmarkDB landmarkDB = LocationBridge.getStore(string);
        return landmarkDB;
    }

    public static Map getLandmarks() {
        return LocationBridge.getLandmarkStores();
    }

    public static void addCategoryToStore(String string, String string2) {
        logger.info((Object)("Adding category " + string + " to " + string2));
        LandmarkDB landmarkDB = LocationBridge.getStore(string2);
        landmarkDB.addCategory(string);
        LocationBridge.saveStores();
    }

    public static void deleteCategoryFromStore(String string, String string2) {
        logger.info((Object)("removing category " + string + " from " + string2));
        LandmarkDB landmarkDB = LocationBridge.getStore(string2);
        landmarkDB.deleteCategory(string);
        LocationBridge.saveStores();
    }

    public static void refresh() {
        landmarkStores = LocationBridge.initStores();
    }

    private static LandmarkDB getStore(String string) {
        if (string == null) {
            return LocationBridge.getDefaultStore();
        }
        return (LandmarkDB)LocationBridge.getLandmarkStores().get(string);
    }

    private static LandmarkDB initDefaultStore() {
        File file = LocationBridge.getDefaultStoreFile();
        file.getParentFile().mkdirs();
        LandmarkDB landmarkDB = new LandmarkDB(null);
        if (!file.exists()) {
            landmarkDB.writeStore(file);
            logger.info((Object)("Wrote Default LandmarkStore to: " + file));
        } else {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                landmarkDB = (LandmarkDB)objectInputStream.readObject();
                objectInputStream.close();
                logger.info((Object)("Read Default LandmarkStore from: " + file));
            }
            catch (Exception exception) {
                logger.info((Object)"", (Throwable)exception);
            }
        }
        logger.info((Object)("Default LandmarkStore:" + landmarkDB));
        return landmarkDB;
    }

    private static Hashtable initStores() {
        LocationBridge.getWorkDir().mkdirs();
        Hashtable<String, LandmarkDB> hashtable = new Hashtable<String, LandmarkDB>();
        try {
            File[] fileArray = LocationBridge.getWorkDir().listFiles(new LMSFileFilter());
            logger.fatal((Object)("Location dir contents: " + fileArray));
            for (int i = 0; i < fileArray.length; ++i) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(fileArray[i]));
                LandmarkDB landmarkDB = (LandmarkDB)objectInputStream.readObject();
                objectInputStream.close();
                String string = fileArray[i].getName();
                string = string.substring(0, string.length() - LMS_EXT.length());
                hashtable.put(string, landmarkDB);
            }
        }
        catch (Exception exception) {
            logger.info((Object)"", (Throwable)exception);
        }
        return hashtable;
    }

    private static void saveStores() {
        LocationBridge.getDefaultStore().writeStore(LocationBridge.getDefaultStoreFile());
        for (String string : LocationBridge.getLandmarkStores().keySet()) {
            LandmarkDB landmarkDB = (LandmarkDB)LocationBridge.getLandmarkStores().get(string);
            landmarkDB.writeStore();
        }
    }

    static {
        instance = null;
    }

    static class LMSFileFilter
    implements FilenameFilter {
        LMSFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(LocationBridge.LMS_EXT);
        }
    }
}

