/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

public enum Orientation {
    NORMAL(0, 0),
    RIGHT(90, 3),
    UPSIDE_DOWN(180, 2),
    LEFT(270, 1);

    private int angle;
    private int midpValue;

    private Orientation(int n2, int n3) {
        this.angle = n2;
        this.midpValue = n3;
    }

    public Orientation rotateClockwise() {
        switch (this) {
            case NORMAL: {
                return RIGHT;
            }
            case RIGHT: {
                return UPSIDE_DOWN;
            }
            case UPSIDE_DOWN: {
                return LEFT;
            }
            case LEFT: {
                return NORMAL;
            }
        }
        return NORMAL;
    }

    public Orientation rotateCounterclockwise() {
        switch (this) {
            case NORMAL: {
                return LEFT;
            }
            case RIGHT: {
                return NORMAL;
            }
            case UPSIDE_DOWN: {
                return RIGHT;
            }
            case LEFT: {
                return UPSIDE_DOWN;
            }
        }
        return NORMAL;
    }

    public int toMidpOrientation() {
        return this.midpValue;
    }

    public static Orientation fromMidpOrientation(int n) {
        for (Orientation orientation : Orientation.values()) {
            if (orientation.midpValue != n) continue;
            return orientation;
        }
        return NORMAL;
    }

    public int toAngle() {
        return this.angle;
    }
}

