/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Orientation;
import com.sun.kvem.PositionTranslator;
import java.awt.Point;
import java.awt.Rectangle;

public class RotateTranslator
implements PositionTranslator {
    Orientation rotation;
    int width;
    int height;

    public RotateTranslator(Orientation orientation, int n, int n2) {
        this.rotation = orientation;
        this.width = n;
        this.height = n2;
    }

    public PositionTranslator getReverseTranslator() {
        Orientation orientation = this.rotation;
        int n = this.width;
        int n2 = this.height;
        switch (this.rotation) {
            case LEFT: {
                orientation = Orientation.RIGHT;
                n = this.height;
                n2 = this.width;
                break;
            }
            case RIGHT: {
                orientation = Orientation.LEFT;
                n = this.height;
                n2 = this.width;
            }
        }
        return new RotateTranslator(orientation, n, n2);
    }

    @Override
    public Point translatePoint(Point point) {
        Point point2 = new Point();
        switch (this.rotation) {
            case NORMAL: {
                point2.x = point.x;
                point2.y = point.y;
                break;
            }
            case LEFT: {
                point2.x = point.y;
                point2.y = this.width - point.x;
                break;
            }
            case UPSIDE_DOWN: {
                point2.x = this.width - point.x;
                point2.y = this.height - point.y;
                break;
            }
            case RIGHT: {
                point2.x = this.height - point.y;
                point2.y = point.x;
            }
        }
        return point2;
    }

    @Override
    public Rectangle translateRect(Rectangle rectangle) {
        Point point = this.translatePoint(new Point(rectangle.x, rectangle.y));
        Point point2 = this.translatePoint(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        return new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
    }
}

