/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.FieldInfo;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.SourceFileAttribute;

class DebuggerListener
extends ProxyListener
implements VMConstants {
    SocketConnection connDebugger;
    ProxyListener KVMListener;
    ClassManager manager = null;
    Packet replyPacket;
    Options options;
    boolean Ready = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;
    boolean stopDebuggerListener = false;
    Thread myThread;
    static boolean options_ready = false;
    int remotePort = 0;

    public DebuggerListener(ServerSocket so, Options opt) {
        this.options = opt;
        this.serverSocket = so;
    }

    public void set(ProxyListener KVMListener2, ClassManager manager) {
        this.KVMListener = KVMListener2;
        this.manager = manager;
    }

    public static void OptionsReady() {
        options_ready = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet p) throws ProxyConnectionException {
        while (!this.Ready) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        String id = String.valueOf(p.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((p.flags & 0xFFFFFF80) == 0 && p.id < 0) {
                this.waitingQueue.put(id, p);
            }
        }
        try {
            this.connDebugger.send(p);
        }
        catch (IOException e) {
            throw new ProxyConnectionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStop() {
        Log.LOGN(3, "Debuggerlistener: setStop called");
        this.myThread.interrupt();
        this.stopDebuggerListener = true;
        Object object = this.packetQueue;
        synchronized (object) {
            this.packetQueue.notify();
        }
        object = this.waitingQueue;
        synchronized (object) {
            this.waitingQueue.notify();
        }
        try {
            if (this.acceptSocket != null) {
                this.acceptSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendErrorReply(ProxyListener proxy, PacketStream in, short errorCode) throws ProxyConnectionException {
        PacketStream ps = new PacketStream(proxy, in.id(), -128, errorCode);
        ps.send();
    }

    public void connectToDebugger() {
        try {
            Log.LOGN(3, "Waiting for debugger on port " + this.serverSocket.getLocalPort());
            this.acceptSocket = this.serverSocket.accept();
            this.connDebugger = new SocketConnection(this, this.acceptSocket);
            Log.LOGN(3, "Debugger connection received. " + this.acceptSocket);
            this.remotePort = this.acceptSocket.getPort();
        }
        catch (IOException e) {
            System.out.println("DebuggerListener0: " + e + " " + e.getMessage());
        }
        catch (SecurityException e) {
            System.out.println("DebuggerListener1: " + e + " " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Packet p = null;
        Object classname = null;
        Object methodname = null;
        Object ps = null;
        PacketStream in = null;
        byte[] handshake = new String("JDWP-Handshake").getBytes();
        this.myThread = Thread.currentThread();
        try {
            int i;
            for (i = 0; i < handshake.length; ++i) {
                this.connDebugger.receiveByte();
            }
            for (i = 0; i < handshake.length; ++i) {
                this.connDebugger.sendByte(handshake[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        DebuggerListener e = this;
        synchronized (e) {
            this.Ready = true;
            this.notify();
        }
        new Thread(this.connDebugger).start();
        proxyMode = Options.getProxyMode();
        try {
            while (!this.stopDebuggerListener) {
                boolean handled = false;
                p = this.waitForPacket();
                if (p == null) {
                    Log.LOGN(3, "DebuggerListener: quitting");
                    this.KVMListener.setStop();
                    break;
                }
                if ((p.flags & 0xFFFFFF80) == 1 || !proxyMode) {
                    Log.LOG(3, "DebuggerListener: ");
                    Log.LOGN(3, p);
                    this.KVMListener.send(p);
                    continue;
                }
                Log.LOG(3, "DebuggerListener: start: " + this.remotePort + ": ");
                Log.LOGN(3, p);
                in = new PacketStream(this, p);
                switch (p.cmdSet) {
                    case 1: {
                        handled = this.doVirtualMachineCmdset(in);
                        break;
                    }
                    case 2: {
                        handled = this.doReferenceTypeCmdset(in);
                        break;
                    }
                    case 6: {
                        handled = this.doMethodCmdset(in);
                        break;
                    }
                    case 11: {
                        handled = this.doThreadReferenceCmdset(in);
                        break;
                    }
                    case 12: {
                        handled = this.doThreadGroupReferenceCmdset(in);
                        break;
                    }
                    case 16: {
                        handled = this.doStackFrameCmdset(in);
                    }
                }
                if (handled) continue;
                Log.LOG(6, "DebuggerListener:" + this.remotePort + ": ");
                Log.LOGN(6, p);
                this.KVMListener.send(p);
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(p.cmdSet + "/" + p.cmd + " caused: " + e2);
            e2.printStackTrace();
            PacketStream error = new PacketStream(this, in.id(), -128, 41);
            error.send();
        }
        catch (ProxyConnectionException e3) {
            Log.LOGN(3, "DebuggerListener: caught ProxyConnectionException");
            this.KVMListener.setStop();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doVirtualMachineCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        switch (in.cmd()) {
            case 1: {
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.writeString("Version 1.0");
                ps.writeInt(1);
                ps.writeInt(0);
                ps.writeString("1.1.3");
                ps.writeString("KVM/CLDC_HI");
                ps.send();
                handled = true;
                break;
            }
            case 2: {
                String classToMatch = null;
                try {
                    ClassFile cf;
                    PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                    classToMatch = in.readString();
                    if (classToMatch == null || classToMatch.length() < 2 || classToMatch.length() == 2 && classToMatch.charAt(0) == 'L') {
                        Log.LOGN(3, "ClassBySig: null class ");
                        ps.writeInt(0);
                        ps.send();
                        handled = true;
                        break;
                    }
                    Log.LOGN(3, "ClassBySig: class " + classToMatch);
                    Iterator iter = this.manager.classMap.values().iterator();
                    while (iter.hasNext()) {
                        cf = (ClassFile)iter.next();
                        if (cf == null) {
                            Log.LOGN(3, "ClassesBySig: Couldn't find classFile object");
                            this.sendErrorReply(this, in, (short)41);
                            handled = true;
                            break;
                        }
                        if (classToMatch.compareTo(cf.getClassSignature()) != 0) continue;
                        Log.LOGN(3, "ClassBySig matched " + cf.getClassName());
                        Log.LOGN(6, "Class Signature: " + cf.getClassSignature());
                        ps.writeInt(1);
                        ps.writeByte(cf.getJDWPTypeTag());
                        ps.writeInt(cf.getClassID());
                        ps.writeInt(cf.getClassStatus());
                        ps.send();
                        handled = true;
                        break;
                    }
                    if (handled) break;
                    Log.LOGN(3, "ClassBySig: class not found: " + classToMatch);
                    VMCall vmCall = new VMCall();
                    cf = vmCall.callVMForClassBySig(classToMatch, "ClassBySig");
                    if (cf == null) {
                        ps.writeInt(0);
                        ps.send();
                        handled = true;
                        break;
                    }
                    int numClasses = vmCall.getNumClasses();
                    Log.LOGN(3, "ClassBySig: VM: numclasses " + numClasses);
                    ps.writeInt(numClasses);
                    if (numClasses > 0) {
                        ps.writeByte(cf.getJDWPTypeTag());
                        ps.writeInt(cf.getClassID());
                        ps.writeInt(cf.getClassStatus());
                    }
                    ps.send();
                    handled = true;
                }
                catch (PacketStreamException e) {
                    Log.LOGN(3, "ClassBySig: VM exception: " + e);
                    this.sendErrorReply(this, in, (short)103);
                    handled = true;
                }
                break;
            }
            case 3: {
                Log.LOGN(3, "All_Classes command");
                PacketStream ps = new PacketStream(this.KVMListener, 1, 3);
                PacketStream ps2 = new PacketStream(this, in.id(), -128, 0);
                ps.send();
                ps.waitForReply();
                int numClasses = ps.readInt();
                ps2.writeInt(numClasses);
                for (int i = 0; i < numClasses; ++i) {
                    byte typeTag = ps.readByte();
                    int cid = ps.readInt();
                    String className = ps.readString();
                    int classStatus = ps.readInt();
                    ps2.writeByte(typeTag);
                    ps2.writeInt(cid);
                    ps2.writeString(className);
                    ps2.writeInt(classStatus);
                    if (typeTag != 3) {
                        className = new String(className.substring(1, className.length() - 1));
                    }
                    Log.LOGN(3, "AllClasses:  " + className + ", ID = " + Log.intToHex(cid));
                    ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                    if (cf == null) {
                        cf = this.manager.findClass(cid, className, typeTag, classStatus);
                        if (cf != null) continue;
                        Log.LOGN(3, "ALL_CLASSES_CMD: couldn't find classfile object");
                        continue;
                    }
                    cf.setClassStatus(classStatus);
                }
                ps2.send();
                handled = true;
                break;
            }
            case 5: {
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.writeInt(1);
                ps.writeInt(-32);
                ps.send();
                handled = true;
                break;
            }
            case 6: {
                Log.LOGN(3, "Dispose");
                if (VM_Version_3) {
                    PacketStream ps = new PacketStream(this.KVMListener, 1, 6);
                    ps.send();
                } else {
                    PacketStream ps = new PacketStream(this.KVMListener, 1, 10);
                    ps.writeInt(0);
                    ps.send();
                }
                PacketStream ps2 = new PacketStream(this, in.id(), -128, 0);
                ps2.send();
                handled = true;
                this.setStop();
                break;
            }
            case 7: {
                while (!options_ready) {
                    DebuggerListener debuggerListener = this;
                    synchronized (debuggerListener) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e) {
                            throw new ProxyConnectionException();
                        }
                    }
                }
                Log.LOGN(3, "IDSizes");
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.writeInt(8);
                if (VM_Version_3) {
                    ps.writeInt(8);
                } else {
                    ps.writeInt(4);
                }
                ps.writeInt(4);
                ps.writeInt(4);
                ps.writeInt(4);
                ps.send();
                handled = true;
                break;
            }
            case 12: {
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.writeBoolean(false);
                ps.writeBoolean(false);
                ps.writeBoolean(true);
                ps.writeBoolean(false);
                ps.writeBoolean(false);
                ps.writeBoolean(false);
                ps.writeBoolean(false);
                ps.send();
                handled = true;
                break;
            }
            case 13: {
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.writeString("");
                ps.writeInt(0);
                ps.writeInt(0);
                ps.send();
                handled = true;
                break;
            }
            case 14: {
                Log.LOGN(3, "Dispose Objects: ");
                PacketStream ps = new PacketStream(this, in.id(), -128, 0);
                ps.send();
                handled = true;
                break;
            }
            case 9: {
                DebuggerListener debuggerListener = this;
                if (!debuggerListener.options.getNetbeans40compat()) break;
                Log.LOGN(3, "Resume Command: ");
                if (--suspendCount >= 0) break;
                Log.LOGN(3, "Resume Command: not forwarding ");
                suspendCount = 0;
                handled = true;
            }
        }
        return handled;
    }

    private boolean doReferenceTypeCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        switch (in.cmd()) {
            case 1: {
                VMCall vmCall;
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    Log.LOGN(3, "Signature cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                Log.LOGN(3, "Signature cmd: class id = " + Log.intToHex(cid));
                if (cid == -32) {
                    ps.writeString("Lkvm_threadgroup;");
                    ps.send();
                    handled = true;
                    break;
                }
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Signature")) == null) {
                    Log.LOGN(3, "Signature cmd: couldn't find classfile object");
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                Log.LOGN(3, "Signature cmd: returning " + cf.getClassSignature());
                ps.writeString(cf.getClassSignature());
                ps.send();
                handled = true;
                break;
            }
            case 2: {
                try {
                    in.readInt();
                }
                catch (PacketStreamException e) {
                    // empty catch block
                }
                ps.writeInt(0);
                ps.send();
                handled = true;
                break;
            }
            case 3: {
                VMCall vmCall;
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    System.out.println("Modifiers cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Modifiers")) == null) {
                    Log.LOGN(3, "Modifiers cmd: Couldn't get ClassFile object");
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                ps.writeInt(cf.getRawAccessFlags());
                ps.send();
                handled = true;
                break;
            }
            case 4: {
                VMCall vmCall;
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    System.out.println("Fields cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                Log.LOGN(3, "field command: cid = " + Log.intToHex(cid));
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Fields")) == null) {
                    Log.LOGN(3, "field_cmd: cf == null");
                    ps.writeInt(0);
                    ps.send();
                    handled = true;
                    break;
                }
                if (this.processFields(cf, ps, in)) {
                    ps.send();
                }
                handled = true;
                break;
            }
            case 5: {
                VMCall vmCall;
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    System.out.println("Methods cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                Log.LOGN(3, "methods command: cid = " + Log.intToHex(cid));
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Methods")) == null) {
                    Log.LOGN(3, "method_cmd: cf == null");
                    ps.writeInt(0);
                    ps.send();
                    handled = true;
                    break;
                }
                if (cf.getJDWPTypeTag() == 3) {
                    Log.LOGN(3, "methods_cmd: cf == arrayclass");
                    ps.writeInt(0);
                    ps.send();
                    handled = true;
                    break;
                }
                Log.LOGN(3, "methods for " + cf.getClassFileName());
                int index = method_index_base;
                ProxyListener.MethodID mid = new ProxyListener.MethodID(cf.getClassID(), index);
                List miList = cf.getAllMethodInfo();
                Iterator iter = miList.iterator();
                Log.LOGN(5, "Methods: " + miList.size() + " methods");
                ps.writeInt(miList.size());
                while (iter.hasNext()) {
                    MethodInfo mi = (MethodInfo)iter.next();
                    if (mi == null) {
                        Log.LOGN(3, "Methods cmd: MethodInfo is null ");
                        this.sendErrorReply(this, in, (short)41);
                        return true;
                    }
                    mid.setMethodPart(index++);
                    Log.LOGN(5, "Method: id = " + mid.toString());
                    mid.writeMethodID(ps);
                    Log.LOGN(5, "Method: name = " + mi.getName());
                    ps.writeString(mi.getName());
                    Log.LOGN(5, "Method: sig = " + mi.getSignatureRaw());
                    ps.writeString(mi.getSignatureRaw());
                    Log.LOGN(5, "Method: flags = " + mi.getAccessFlags());
                    ps.writeInt(mi.getAccessFlags());
                }
                ps.send();
                handled = true;
                break;
            }
            case 7: {
                VMCall vmCall;
                int cid;
                Log.LOGN(3, "Source file cmd");
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    System.out.println("Sourcefile cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "SourceFile")) == null) {
                    Log.LOGN(3, "Sourcefile cmd: Couldn't get ClassFile object");
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                SourceFileAttribute sfAttr = cf.getSourceAttribute();
                if (sfAttr != null) {
                    String s = sfAttr.getSourceFileName();
                    Log.LOGN(3, "Returning from attribute: " + s);
                    ps.writeString(s);
                } else {
                    Log.LOGN(3, "Creating source name: " + cf.getBaseName() + ".java");
                    ps.writeString(cf.getBaseName() + ".java");
                }
                ps.send();
                handled = true;
                break;
            }
            case 9: {
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    Log.LOGN(3, "status cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                VMCall vmCall = new VMCall();
                ClassFile cf = vmCall.callVMForClass(cid, "Status");
                if (cf == null) {
                    Log.LOGN(3, "Status cmd: Couldn't get ClassFile object ");
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                ps.writeInt(cf.getClassStatus());
                ps.send();
                handled = true;
                break;
            }
            case 10: {
                VMCall vmCall;
                int cid;
                try {
                    cid = in.readInt();
                }
                catch (PacketStreamException e) {
                    System.out.println("Interfaces cmd: exception: " + e);
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                Log.LOGN(3, "Interface cmd: class id " + Log.intToHex(cid));
                ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Interfaces")) == null) {
                    Log.LOGN(3, "Interfaces cmd: Couldn't get ClassFile object for id = " + Log.intToHex(cid));
                    this.sendErrorReply(this, in, (short)20);
                    handled = true;
                    break;
                }
                List iList = cf.getAllInterfaces();
                Iterator iIter = iList.iterator();
                Log.LOGN(3, "Interfaces: class " + cf.getClassName() + " " + iList.size() + " interfaces");
                ps.writeInt(iList.size());
                while (iIter.hasNext()) {
                    String className = (String)iIter.next();
                    Log.LOGN(3, "interfaces: interfacename: " + className);
                    if (className == null) {
                        Log.LOGN(3, "Interfaces cmd: interface name is null");
                        this.sendErrorReply(this, in, (short)20);
                        return true;
                    }
                    cf = this.manager.findClass((byte)76, className);
                    if (cf == null) {
                        VMCall vmCall2 = new VMCall();
                        String sig = "L" + className + ";";
                        cf = vmCall2.callVMForClassBySig(sig, "Interfaces");
                        if (cf == null) {
                            Log.LOGN(3, "interfaces: classname: null ClassFile");
                            ps.writeInt(0);
                            continue;
                        }
                        Log.LOGN(3, "interfaces: classID: " + cf.getClassID());
                        ps.writeInt(cf.getClassID());
                        continue;
                    }
                    Log.LOGN(3, "interfaces: classID: " + cf.getClassID());
                    ps.writeInt(cf.getClassID());
                }
                ps.send();
                handled = true;
            }
        }
        return handled;
    }

    private boolean doMethodCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        switch (in.cmd()) {
            case 1: {
                this.lineTable(in);
                handled = true;
                break;
            }
            case 2: {
                this.variableTable(in);
                handled = true;
                break;
            }
            case 3: {
                this.byteCode(in);
                handled = true;
            }
        }
        return handled;
    }

    private boolean doThreadReferenceCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        switch (in.cmd()) {
            case 5: {
                Log.LOGN(3, "Threadreference: threadgroup");
                ps.writeInt(-32);
                ps.send();
                handled = true;
            }
        }
        return handled;
    }

    private boolean doThreadGroupReferenceCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        int tgID = 0;
        try {
            tgID = in.readInt();
        }
        catch (PacketStreamException e) {
            Log.LOGN(3, "ThreadGroup cmd: exception: " + e);
        }
        switch (in.cmd()) {
            case 1: {
                Log.LOGN(3, "ThreadGroup: name");
                ps.writeString("KVM_System");
                ps.send();
                handled = true;
                break;
            }
            case 2: {
                Log.LOGN(3, "ThreadGroup: parent");
                ps.writeInt(0);
                ps.send();
                handled = true;
                break;
            }
            case 3: {
                Log.LOGN(3, "ThreadGroup: children");
                if (tgID == -32) {
                    PacketStream ps2 = new PacketStream(this.KVMListener, 1, 4);
                    ps2.send();
                    try {
                        ps2.waitForReply();
                    }
                    catch (ProxyConnectionException e) {
                        ps.writeInt(0);
                        ps.writeInt(0);
                        ps.send();
                        handled = true;
                        break;
                    }
                    int numThreads = ps2.readInt();
                    Log.LOGN(3, "threadgroup: " + numThreads + " children");
                    ps.writeInt(numThreads);
                    while (numThreads-- > 0) {
                        ps.writeInt(ps2.readInt());
                    }
                } else {
                    ps.writeInt(0);
                }
                ps.writeInt(0);
                ps.send();
                handled = true;
            }
        }
        return handled;
    }

    private boolean doStackFrameCmdset(PacketStream in) throws ProxyConnectionException {
        boolean handled = false;
        int frame_index_adjust = 1;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        switch (in.cmd()) {
            case 3: {
                Log.LOGN(3, "Stackframe: thisobject");
                int tID = in.readInt();
                int fID = in.readInt();
                PacketStream ps2 = new PacketStream(this.KVMListener, 11, 6);
                ps2.writeInt(tID);
                ps2.writeInt(0);
                ps2.writeInt(1);
                ps2.send();
                try {
                    ps2.waitForReply();
                    ps2.readInt();
                    int id = ps2.readInt();
                    if (id == 0) {
                        frame_index_adjust = 0;
                    }
                }
                catch (ProxyConnectionException e) {
                    // empty catch block
                }
                ps2 = new PacketStream(this.KVMListener, 11, 6);
                ps2.writeInt(tID);
                ps2.writeInt(fID - frame_index_adjust);
                ps2.writeInt(1);
                ps2.send();
                try {
                    VMCall vmCall;
                    ClassFile cf = null;
                    ps2.waitForReply();
                    ps2.readInt();
                    int fID2 = ps2.readInt();
                    if (fID2 != fID) {
                        Log.LOGN(3, "Stackframe: thisobject: mismatched frames");
                        throw new ProxyConnectionException();
                    }
                    byte typeTag = ps2.readByte();
                    if (typeTag != 1) {
                        Log.LOGN(3, "Stackframe: thisobject: wrong type tag");
                        throw new ProxyConnectionException();
                    }
                    int cid = ps2.readInt();
                    ProxyListener.MethodID mid = new ProxyListener.MethodID();
                    int methodIndex = mid.readMethodPart(ps2) - method_index_base;
                    cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
                    if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "ThisObject")) == null) {
                        Log.LOGN(3, "Stackframe: thisobject: could not find class object");
                        throw new ProxyConnectionException();
                    }
                    MethodInfo mi = cf.getMethodInfoByIndex(methodIndex);
                    if (mi == null) {
                        Log.LOGN(3, "Stackframe: thisobject: could not find method object");
                        throw new ProxyConnectionException();
                    }
                    if (mi.is_static()) {
                        ps.writeByte((byte)76);
                        ps.writeInt(0);
                        ps.send();
                        handled = true;
                        break;
                    }
                }
                catch (ProxyConnectionException e) {
                    // empty catch block
                }
                ps2 = new PacketStream(this.KVMListener, 16, 1);
                ps2.writeInt(tID);
                ps2.writeInt(fID);
                ps2.writeInt(1);
                ps2.writeInt(0);
                ps2.writeByte((byte)76);
                ps2.send();
                try {
                    ps2.waitForReply();
                }
                catch (ProxyConnectionException e) {
                    ps.writeByte((byte)76);
                    ps.writeInt(0);
                    ps.send();
                    handled = true;
                    break;
                }
                int num = ps2.readInt();
                byte tag = ps2.readByte();
                int objectID = ps2.readInt();
                Log.LOGN(3, "Stackframe: thisobject tag: " + tag + " objectID " + Log.intToHex(objectID));
                ps.writeByte(tag);
                ps.writeInt(objectID);
                ps.send();
                handled = true;
            }
        }
        return handled;
    }

    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] classid) {
        return new String("");
    }

    protected String getMethodName(byte[] methodid) {
        return new String("");
    }

    protected boolean processFields(ClassFile cf, PacketStream ps, PacketStream in) {
        Log.LOGN(3, "processFields for " + cf.getClassFileName());
        List fiList = cf.getAllFieldInfo();
        if (fiList == null) {
            ps.writeInt(0);
            return true;
        }
        Iterator fiIter = fiList.iterator();
        long fieldID = (long)cf.getClassID() << 32;
        Log.LOGN(5, "field class id is " + Log.intToHex(cf.getClassID()) + " fieldid is " + Log.longToHex(fieldID));
        ps.writeInt(fiList.size());
        while (fiIter.hasNext()) {
            FieldInfo fi = (FieldInfo)fiIter.next();
            if (fi == null) {
                Log.LOGN(3, "Fields cmd: fieldinfo null ");
                this.sendErrorReply(this, in, (short)20);
                return false;
            }
            Log.LOGN(5, "Field: id = " + Log.longToHex(fieldID));
            ps.writeLong(fieldID++);
            Log.LOGN(5, "Field: name = " + fi.getName());
            ps.writeString(fi.getName());
            Log.LOGN(5, "Field: sig = " + fi.getType());
            ps.writeString(fi.getType());
            Log.LOGN(5, "Field: flags = " + fi.getAccessFlags());
            ps.writeInt(fi.getAccessFlags());
        }
        return true;
    }

    public void lineTable(PacketStream in) {
        int lineCount;
        ClassFile cf = null;
        int[][] code = null;
        long endingOffset = -1L;
        long startingOffset = -1L;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        int cid = in.readInt();
        ProxyListener.MethodID mid = new ProxyListener.MethodID();
        int methodIndex = mid.readMethodPart(in) - method_index_base;
        if (VM_Version_3) {
            PacketStream ps2 = new PacketStream(this.KVMListener, -128, 5);
            ps2.writeInt(cid);
            mid.writeMethodID(ps2);
            ps2.send();
            try {
                ps2.waitForReply();
                int num_entries = ps2.readInt();
                Log.LOGN(3, "linenumber table: VM returned " + num_entries + " entries.");
                if (num_entries > 0) {
                    startingOffset = ps2.readLong();
                    endingOffset = ps2.readLong();
                    code = new int[num_entries][2];
                    for (int i = 0; i < num_entries; ++i) {
                        code[i][0] = ps2.readShort();
                        code[i][1] = ps2.readShort();
                    }
                }
            }
            catch (ProxyConnectionException e) {
                code = null;
            }
        }
        if (code == null) {
            VMCall vmCall;
            Log.LOGN(4, "linetable: class id= " + Log.intToHex(cid) + ", method id= " + mid.toString());
            cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
            if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "LineTable")) == null) {
                Log.LOGN(3, "Linetable cmd: not found");
                this.sendErrorReply(this, in, (short)41);
                return;
            }
            Log.LOGN(4, "linetable: class: " + cf.getClassFileName());
            MethodInfo mi = cf.getMethodInfoByIndex(methodIndex);
            if (mi == null) {
                Log.LOGN(1, "Couldn't find methodinfo for index " + mid + method_index_base);
                this.sendErrorReply(this, in, (short)23);
                return;
            }
            CodeAttribute ca = mi.getCodeAttribute();
            if (ca == null) {
                endingOffset = -1L;
                startingOffset = -1L;
            } else {
                startingOffset = 0L;
                endingOffset = ca.getCodeLength() - 1;
            }
            code = mi.getBreakableLineNumbers();
        }
        if (code == null) {
            Log.LOGN(1, "No linenumber table found for class " + cf.getClassName());
            lineCount = 0;
        } else {
            lineCount = code.length;
        }
        ps.writeLong(startingOffset);
        ps.writeLong(endingOffset);
        Log.LOGN(5, "Starting code offset = " + startingOffset + ", Ending code offset = " + endingOffset);
        Log.LOGN(5, "Code Length = " + lineCount);
        ps.writeInt(lineCount);
        for (int i = 0; i < lineCount; ++i) {
            ps.writeLong(code[i][0]);
            ps.writeInt(code[i][1]);
            Log.LOGN(5, "  index=" + code[i][0] + " l#=" + code[i][1]);
        }
        ps.send();
    }

    public void variableTable(PacketStream in) {
        int i;
        VMCall vmCall;
        List table = null;
        MethodInfo mi = null;
        boolean use_agent_table = true;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        int cid = in.readInt();
        Log.LOGN(3, "variable: class id = " + Log.intToHex(cid));
        ProxyListener.MethodID mid = new ProxyListener.MethodID();
        int methodIndex = mid.readMethodPart(in) - method_index_base;
        ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
        if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "VariableTable")) == null) {
            Log.LOGN(3, "Variabletable cmd: not found");
            this.sendErrorReply(this, in, (short)41);
            return;
        }
        Log.LOGN(3, "variable: method id = " + mid.toString());
        table = cf.getVariableTableForMethodIndex(methodIndex);
        mi = cf.getMethodInfoByIndex(methodIndex);
        if (mi == null) {
            Log.LOGN(3, "HandleVariableTable: Couldn't find method info for class " + cf.getClassName());
            this.sendErrorReply(this, in, (short)20);
            return;
        }
        short[][] VM_var_table = null;
        if (VM_Version_3) {
            PacketStream ps2 = new PacketStream(this.KVMListener, -128, 4);
            ps2.writeInt(cid);
            mid.writeMethodID(ps2);
            ps2.send();
            try {
                ps2.waitForReply();
                int num_entries = ps2.readInt();
                Log.LOGN(3, "variable: VM returned " + num_entries + " entries.");
                if (num_entries > 0) {
                    use_agent_table = false;
                    VM_var_table = new short[num_entries][3];
                    for (i = 0; i < num_entries; ++i) {
                        VM_var_table[i][0] = ps2.readShort();
                        VM_var_table[i][1] = ps2.readShort();
                        VM_var_table[i][2] = ps2.readShort();
                    }
                }
            }
            catch (ProxyConnectionException e) {
                use_agent_table = true;
            }
            catch (PacketStreamException e) {
                use_agent_table = true;
            }
        }
        int argCount = mi.getArgCount();
        Log.LOGN(3, "variable: argcount is " + argCount);
        ps.writeInt(argCount);
        i = 0;
        if (table != null) {
            Log.LOGN(3, "variable: table size is " + table.size());
            ps.writeInt(table.size());
            Iterator iter = table.iterator();
            while (iter.hasNext()) {
                LocalVariable var = (LocalVariable)iter.next();
                if (use_agent_table) {
                    ps.writeLong(var.getCodeIndex());
                } else {
                    ps.writeLong(VM_var_table[i][0]);
                }
                ps.writeString(var.getName());
                ps.writeString(this.getJNISignature(var.getType()));
                if (use_agent_table) {
                    ps.writeInt(var.getLength());
                } else {
                    ps.writeInt(VM_var_table[i][1]);
                }
                if (use_agent_table) {
                    ps.writeInt(var.getSlot());
                } else {
                    ps.writeInt(VM_var_table[i][2]);
                }
                ++i;
            }
        } else {
            ps.writeInt(0);
        }
        ps.send();
    }

    private void byteCode(PacketStream in) {
        int code_length;
        VMCall vmCall;
        MethodInfo mi = null;
        PacketStream ps = new PacketStream(this, in.id(), -128, 0);
        Log.LOGN(1, "Method: Bytecodes");
        Object sig = null;
        int cid = in.readInt();
        Log.LOGN(3, "class id=0x" + Log.intToHex(cid));
        ProxyListener.MethodID mid = new ProxyListener.MethodID();
        int methodIndex = mid.readMethodPart(in) - method_index_base;
        ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
        if (cf == null && (cf = (vmCall = new VMCall()).callVMForClass(cid, "Fields")) == null) {
            Log.LOGN(3, "Bytecode cmd: not found");
            this.sendErrorReply(this, in, (short)20);
            return;
        }
        Log.LOGN(3, "method id=0x" + mid.toString());
        mi = cf.getMethodInfoByIndex(methodIndex);
        if (mi == null) {
            Log.LOGN(3, "HandleByteCode: couldn't find method info for class " + cf.getClassFileName());
            this.sendErrorReply(this, in, (short)23);
            return;
        }
        CodeAttribute ca = mi.getCodeAttribute();
        byte[] code = null;
        if (ca == null) {
            code_length = 0;
        } else {
            code = mi.getCodeAttribute().getByteCodes();
            code_length = code.length;
        }
        ps.writeInt(code_length);
        if (code_length > 0) {
            ps.writeByteArray(code);
        }
        ps.send();
    }

    private String getJNISignature(String type) {
        int index;
        int preindex = index = type.length();
        String ret = new String();
        Log.LOGN(6, "getJNISignature()  type == " + type);
        while ((index = type.lastIndexOf("[]", index)) != -1) {
            ret = ret + "[";
            preindex = index--;
        }
        String str = type.substring(0, preindex);
        ret = "int".equalsIgnoreCase(str) ? ret + "I" : ("boolean".equalsIgnoreCase(str) ? ret + "Z" : ("short".equalsIgnoreCase(str) ? ret + "S" : ("byte".equalsIgnoreCase(str) ? ret + "B" : ("char".equalsIgnoreCase(str) ? ret + "C" : ("long".equalsIgnoreCase(str) ? ret + "J" : ("float".equalsIgnoreCase(str) ? ret + "F" : ("double".equalsIgnoreCase(str) ? ret + "D" : ret + "L" + str.replace('.', '/') + ";")))))));
        return ret;
    }

    class VMCall {
        int numClasses;

        VMCall() {
        }

        protected ClassFile callVMForClass(int cid, String command) {
            PacketStream ps;
            if (!ProxyListener.VM_Version_3) {
                return null;
            }
            Log.LOGN(3, command + " cmd: calling VM");
            try {
                ps = new PacketStream(DebuggerListener.this.KVMListener, 2, 1);
                ps.writeInt(cid);
                ps.send();
                ps.waitForReply();
            }
            catch (PacketStreamException e) {
                Log.LOGN(3, command + " cmd: Couldn't get ClassFile object");
                return null;
            }
            String className = ps.readString();
            Log.LOGN(3, command + " cmd: VM returned " + className);
            try {
                ps = new PacketStream(DebuggerListener.this.KVMListener, 1, 2);
                ps.writeString(className);
                ps.send();
                ps.waitForReply();
            }
            catch (PacketStreamException e) {
                Log.LOGN(3, command + " cmd: Couldn't get Class info");
                return null;
            }
            ps.readInt();
            byte typeTag = ps.readByte();
            int newCid = ps.readInt();
            int classStatus = ps.readInt();
            if (cid != newCid) {
                Log.LOGN(3, command + " cmd: class id mismatch: old " + cid + " new " + newCid);
            }
            Log.LOGN(3, command + " cmd: VM returned: tag:  " + typeTag + ", cid " + newCid + ", status " + classStatus);
            String newClassName = className;
            if (typeTag != 3) {
                newClassName = new String(className.substring(1, className.length() - 1));
            }
            ClassFile cf = DebuggerListener.this.manager.findClass(newCid, newClassName, typeTag, classStatus);
            return cf;
        }

        protected ClassFile callVMForClassBySig(String sig, String command) {
            if (!ProxyListener.VM_Version_3) {
                return null;
            }
            PacketStream ps = new PacketStream(DebuggerListener.this.KVMListener, 1, 2);
            ps.writeString(sig);
            ps.send();
            ps.waitForReply();
            this.numClasses = ps.readInt();
            Log.LOGN(3, command + ": VM: numclasses " + this.numClasses);
            if (this.numClasses > 0) {
                byte typeTag = ps.readByte();
                int cid = ps.readInt();
                int classStatus = ps.readInt();
                String className = new String(sig);
                if (typeTag != 3) {
                    className = new String(className.substring(1, className.length() - 1));
                }
                Log.LOGN(3, command + ": VM class found: " + Log.intToHex(cid));
                ClassFile cf = DebuggerListener.this.manager.findClass(cid, className, typeTag, classStatus);
                if (cf == null) {
                    Log.LOGN(3, command + ": couldn't find classfile object");
                }
                return cf;
            }
            return null;
        }

        protected int getNumClasses() {
            return this.numClasses;
        }
    }
}

