/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import kdp.DebuggerListener;
import kdp.KVMListener;
import kdp.Log;
import kdp.Options;
import kdp.classparser.ClassManager;
import kdp.classparser.SearchPath;

public class KVMDebugProxy {
    Options options = null;

    public boolean parseArgs(String[] args) {
        int i = 0;
        this.options = new Options();
        Options.setLocalPort(2801);
        Options.setRemotePort(2800);
        Options.setRemoteHost("localhost");
        Options.setVerbosity(0);
        Options.setClassPath("./");
        Options.setProxyMode(false);
        if (args.length == 0) {
            this.options = null;
        }
        try {
            while (i < args.length) {
                if ("-l".equals(args[i])) {
                    Options.setLocalPort(Integer.parseInt(args[++i]));
                } else if ("-r".equals(args[i])) {
                    Options.setRemoteHost(args[++i]);
                    Options.setRemotePort(Integer.parseInt(args[++i]));
                } else if ("-v".equals(args[i])) {
                    Options.setVerbosity(Integer.parseInt(args[++i]));
                } else if ("-cp".equals(args[i]) || "-classpath".equals(args[i])) {
                    Options.setClassPath(args[++i]);
                } else if ("-p".equals(args[i])) {
                    Options.setProxyMode(true);
                } else if ("-m".equals(args[i])) {
                    Options.setUseMVM(true);
                } else if ("-nb4".equals(args[i])) {
                    Options.setNetbeans40compat(true);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.options = null;
        }
        return this.options != null;
    }

    public void help() {
        System.out.println("J2ME Debug Agent Copyright (c) 2000 Sun Microsystems, Inc. All rights reserved.");
        System.out.println();
        System.out.println("Usage: KVMDebugProxy -l <localport> -r <remotehost> <remoteport> [-p]");
        System.out.println("        [-v <level>] [-cp | - classpath <classpath" + File.pathSeparator + "classpath...>]");
        System.out.println("Where:");
        System.out.println("  -l <localport> specifies the local port number that the debug agent will");
        System.out.println("     listen on for a connection from a debugger.");
        System.out.println("  -r <remotehost> <remoteport> is the hostname and port number that the debug");
        System.out.println("     agent will use to connect to the Java VM running the application");
        System.out.println("     being debugged");
        System.out.println("  -p enables proxy mode, the debug agent processes classfiles on behalf of the Java VM ");
        System.out.println("     running the application being debugged.  If not present, all commands");
        System.out.println("     from the debugger are passed down to the Java VM running the application");
        System.out.println("  -v <level> turns on verbose mode.  'level' specifies the amount of output,");
        System.out.println("     the larger the number the more output that is generated.");
        System.out.println("     'level' can be from 1-9.");
        System.out.println("  -m Enable support for Multitasking VM.");
        System.out.println("  -nb4 Enable use of Netbeans 4.x with older VMs (version < CLDC_HI 1.1.3)");
        System.out.println("  -cp or -classpath specifies a list of paths separated by " + File.pathSeparator + " where the");
        System.out.println("     debug agent can find copies of the class files.  Only needed if -p is set.");
        System.out.println();
    }

    public void go() {
        ServerSocket serverSocket = null;
        if (this.options == null) {
            return;
        }
        KVMDebugProxy kVMDebugProxy = this;
        Log.SET_LOG(kVMDebugProxy.options.getVerbosity());
        try {
            KVMDebugProxy kVMDebugProxy2 = this;
            serverSocket = new ServerSocket(kVMDebugProxy2.options.getLocalPort());
            Log.LOGN(3, "KVMDebugProxy: opened server socket " + serverSocket);
        }
        catch (IOException e) {
            System.out.println("Caught exception " + e + " while creating listener socket");
            return;
        }
        do {
            try {
                KVMDebugProxy kVMDebugProxy3 = this;
                ClassManager manager = new ClassManager(new SearchPath(kVMDebugProxy3.options.getClassPath()));
                DebuggerListener dlisten = new DebuggerListener(serverSocket, this.options);
                KVMListener klisten = new KVMListener();
                dlisten.set(klisten, manager);
                klisten.set(dlisten, manager);
                new Thread(klisten).start();
                KVMDebugProxy kVMDebugProxy4 = this;
                dlisten.verbose(kVMDebugProxy4.options.getVerbosity());
                KVMDebugProxy kVMDebugProxy5 = this;
                klisten.verbose(kVMDebugProxy5.options.getVerbosity());
                dlisten.connectToDebugger();
                new Thread(dlisten).start();
            }
            catch (SecurityException e) {
                System.out.println("KVMDebugProxy: " + e.getMessage());
            }
            KVMDebugProxy kVMDebugProxy6 = this;
        } while (kVMDebugProxy6.options.getUseMVM());
    }

    public static void main(String[] args) {
        KVMDebugProxy kdp = new KVMDebugProxy();
        if (!kdp.parseArgs(args)) {
            kdp.help();
            System.exit(1);
        }
        kdp.go();
    }
}

