/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Map;
import kdp.DebuggerListener;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;

class KVMListener
extends ProxyListener
implements VMConstants {
    SocketConnection connKvm;
    ProxyListener debuggerListener = null;
    ClassManager manager;
    boolean Ready = false;
    Socket remoteSocket = null;
    boolean stopKVMListener = false;
    Thread myThread;
    int localPort = 0;

    public KVMListener() {
        proxyMode = Options.getProxyMode();
    }

    public void set(ProxyListener debuggerListener, ClassManager manager) {
        this.debuggerListener = debuggerListener;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet p) throws ProxyConnectionException {
        while (!this.Ready) {
            KVMListener kVMListener = this;
            synchronized (kVMListener) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (p == null) {
            return;
        }
        String id = String.valueOf(p.id);
        if ((p.flags & 0xFFFFFF80) == 0 && p.id < 0) {
            Map e = this.waitingQueue;
            synchronized (e) {
                this.waitingQueue.put(id, p);
            }
        }
        try {
            this.connKvm.send(p);
        }
        catch (IOException e) {
            throw new ProxyConnectionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStop() {
        Log.LOGN(3, "KVMlistener: setStop called");
        this.stopKVMListener = true;
        this.myThread.interrupt();
        Object object = this.packetQueue;
        synchronized (object) {
            this.packetQueue.notify();
        }
        object = this.waitingQueue;
        synchronized (object) {
            this.waitingQueue.notify();
        }
        try {
            if (this.remoteSocket != null) {
                this.remoteSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object handshake;
        this.myThread = Thread.currentThread();
        try {
            while (this.remoteSocket == null) {
                try {
                    Log.LOGN(3, "KVMListener: attempting connection");
                    this.remoteSocket = new Socket(Options.getRemoteHost(), Options.getRemotePort());
                    Log.LOGN(3, "KVMListener: got connection " + this.remoteSocket);
                }
                catch (ConnectException e) {
                    System.err.println("KVMListener: Exception " + e + " KVM not ready");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            this.localPort = this.remoteSocket.getLocalPort();
            this.connKvm = new SocketConnection(this, this.remoteSocket);
        }
        catch (IOException e) {
            System.out.println("KVMListener: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.out.println("KVMListener: " + e.getMessage());
        }
        if (!proxyMode) {
            handshake = new String("JDWP-Handshake").getBytes();
            try {
                int i;
                for (i = 0; i < ((Object)handshake).length; ++i) {
                    this.connKvm.sendByte((byte)handshake[i]);
                }
                for (i = 0; i < ((Object)handshake).length; ++i) {
                    this.connKvm.receiveByte();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        handshake = this;
        synchronized (handshake) {
            this.Ready = true;
            this.notify();
        }
        new Thread(this.connKvm).start();
        if (proxyMode) {
            PacketStream ps = new PacketStream(this, -128, 1);
            ps.writeString("KVM Reference Debugger Agent");
            ps.writeByte((byte)1);
            ps.writeByte((byte)4);
            try {
                ps.send();
                ps.waitForReply();
            }
            catch (Exception e) {
                System.out.println("Exception during handshake: " + e + " exiting...");
                Runtime.getRuntime().exit(1);
            }
            String s = ps.readString();
            int option_bits = ps.readInt();
            Log.LOGN(1, "KVM Handshake return string: " + s);
            Log.LOGN(1, "KVM Handshake return options: " + Log.intToHex(option_bits));
            if ((option_bits & 0x18000) >> 15 == 2) {
                Log.LOGN(1, "Method index base being set to 1");
                method_index_base = 1;
            }
            if ((option_bits & 0x60000) >> 17 == 2) {
                Log.LOGN(1, "VM has line number table");
                Log.LOGN(1, "VM supports DISPOSE command");
                Log.LOGN(1, "VM supports ClassesBySig command");
                VM_Version_3 = true;
            }
        }
        DebuggerListener.OptionsReady();
        try {
            while (!this.stopKVMListener) {
                boolean handled = false;
                Packet p = this.waitForPacket();
                if (p == null) {
                    Log.LOGN(3, "KVMListener: quitting");
                    this.debuggerListener.setStop();
                    return;
                }
                Log.LOG(3, "KVMListener: start:" + this.localPort + ": ");
                Log.LOGN(3, p);
                if (proxyMode && (p.flags & 0xFFFFFF80) == 0) {
                    switch (p.cmdSet) {
                        case 64: {
                            PacketStream in;
                            switch (p.cmd) {
                                case 100: {
                                    in = new PacketStream(this, p);
                                    byte suspendPolicy = in.readByte();
                                    if (suspendPolicy > 0) {
                                        ++suspendCount;
                                    }
                                    int numEvents = in.readInt();
                                    byte eventKind = in.readByte();
                                    if (eventKind != 8) break;
                                    int requestID = in.readInt();
                                    int threadID = in.readInt();
                                    byte typeTag = in.readByte();
                                    int classID = in.readInt();
                                    String className = in.readString();
                                    int classStatus = in.readInt();
                                    if (typeTag != 3) {
                                        className = new String(className.substring(1, className.length() - 1));
                                    }
                                    Log.LOGN(3, "ClassPrepare:  " + className + ", ID = " + Log.intToHex(classID));
                                    ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(classID));
                                    if (cf == null) {
                                        cf = this.manager.findClass(classID, className, typeTag, classStatus);
                                        if (cf == null) {
                                            Log.LOGN(3, "ClassPrepare: Could not load classfile " + className);
                                            break;
                                        }
                                    } else {
                                        Log.LOGN(3, "ClassPrepare: got classfile " + cf.getClassName());
                                        cf.setClassStatus(classStatus);
                                    }
                                }
                            }
                            break;
                        }
                        case -128: {
                            PacketStream in;
                            switch (p.cmd) {
                                case 3: {
                                    in = new PacketStream(this, p);
                                    this.handleSteppingInfo(in);
                                    handled = true;
                                }
                            }
                            break;
                        }
                    }
                }
                if (handled) continue;
                Log.LOG(6, "KVMListener:" + this.localPort + ": ");
                Log.LOGN(6, p);
                this.debuggerListener.send(p);
            }
            return;
        }
        catch (ProxyConnectionException e) {
            Log.LOGN(3, "KVMListener: caught ProxyConnectionException");
            this.debuggerListener.setStop();
            return;
        }
    }

    private void handleSteppingInfo(PacketStream in) throws ProxyConnectionException {
        int currentIndex;
        long offs;
        long offs2;
        long offs3;
        MethodInfo mi;
        int cep = in.readInt();
        int cid = in.readInt();
        ProxyListener.MethodID mid = new ProxyListener.MethodID();
        int methodIndex = mid.readMethodPart(in) - method_index_base;
        long offset = in.readLong();
        Log.LOGN(3, "handleSteppingInfo: cep = " + Log.intToHex(cep) + " cid = " + Log.intToHex(cid) + " mid = " + mid.toString());
        PacketStream ps = new PacketStream(this, -128, 2);
        ps.writeInt(cep);
        ClassFile cf = (ClassFile)this.manager.classMap.get(new Integer(cid));
        if (cf == null || (mi = cf.getMethodInfoByIndex(methodIndex)) == null) {
            ps.writeLong(0L);
            ps.writeLong(0L);
            ps.send();
            ps.waitForReply();
            return;
        }
        LineNumberTableAttribute table = null;
        CodeAttribute ca = mi.getCodeAttribute();
        if (ca != null) {
            table = ca.getLineNumberTable();
        }
        if (ca == null || table == null) {
            offs3 = -1L;
            offs2 = -1L;
            offs = -1L;
            currentIndex = -1;
            int index2 = -1;
            int index = -1;
        } else {
            currentIndex = table.getCurrentLineCodeIndex(offset);
            int index = table.getNextExecutableLineCodeIndex(offset);
            int index2 = table.getDupCurrentExecutableLineCodeIndex(offset);
            offs = table.getStartPCFromIndex(index);
            offs2 = table.getStartPCFromIndex(index2);
            offs3 = table.getOffsetofDupNextLine(index2);
        }
        Log.LOGN(3, "handleSteppingInfo  current offset = " + offset);
        Log.LOGN(3, "handleSteppingInfo  target offset = " + offs);
        Log.LOGN(3, "handleSteppingInfo  dup of current line offset = " + offs2);
        Log.LOGN(3, "handleSteppingInfo  offset after current dup = " + offs3);
        if (table != null) {
            Log.LOGN(3, "handleSteppingInfo current line number = " + table.getLineNumberFromIndex(currentIndex));
        }
        ps.writeLong(offs);
        ps.writeLong(offs2);
        ps.writeLong(offs3);
        ps.send();
        ps.waitForReply();
    }

    public String toString() {
        return new String("KVMListener: ");
    }
}

