/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import kdp.Options;
import kdp.VMConstants;

public class Packet
implements VMConstants {
    public static final byte NoFlags = 0;
    public static final byte Reply = -128;
    public static final byte ReplyNoError = 0;
    static int uID = -2147483647;
    static final byte[] nullData = new byte[0];
    int id = Packet.uniqID();
    byte flags = 0;
    byte cmdSet;
    byte cmd;
    short errorCode;
    byte[] data = null;
    volatile boolean replied = false;
    int curReadIndex = 0;
    int curWriteIndex = 0;

    Packet() {
    }

    private static synchronized int uniqID() {
        return uID++;
    }

    public int getLength() {
        return this.curWriteIndex;
    }

    public String toString() {
        String[][] cmds;
        int cmdSetIndex = this.cmdSet;
        int cmdIndex = this.cmd;
        if (this.cmdSet < 64) {
            cmds = VMConstants.VMcmds;
        } else if (this.cmdSet < 128) {
            cmds = VMConstants.DBGcmds;
            cmdSetIndex -= 64;
            cmdIndex -= 99;
        } else {
            cmds = VMConstants.VENcmds;
            cmdIndex = 0;
            cmdSetIndex = 0;
        }
        StringBuffer s = new StringBuffer();
        try {
            s.append("Sending through: ");
            s.append(cmds[cmdSetIndex][0]);
            s.append("(");
            s.append(this.cmdSet);
            s.append(")/");
            s.append(cmds[cmdSetIndex][cmdIndex]);
            s.append("(");
            s.append(this.cmd);
            s.append(")\n");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("UNKNOWN COMMAND: " + this.cmdSet + "/" + this.cmd);
        }
        if (Options.getVerbosity() >= 5) {
            s.append(this.cmdSet);
            s.append("/");
            s.append(this.cmd);
            s.append("/");
            s.append(this.errorCode);
            s.append("/");
            s.append(this.id);
        }
        if (Options.getVerbosity() >= 8) {
            s.append("\n--->\n");
            for (int i = 0; i < this.data.length; ++i) {
                s.append(Integer.toHexString((int)((long)this.data[i] & 0xFFL))).append(".");
            }
            s.append("\n<----");
        }
        if (this.cmdSet == 15 && this.cmd == 1) {
            s.append("\nEventKind == ").append(this.data[0]).append("\n");
        } else if (this.cmdSet == 64 && this.cmd == 100) {
            s.append("\nEventKind == ").append(this.data[5]).append("\n");
        }
        return s.toString();
    }
}

