/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import kdp.Packet;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;

class PacketStream {
    final ProxyListener proxy;
    private int outCursor = 0;
    final Packet pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;
    private int id;
    byte[] data;

    PacketStream(ProxyListener proxy, byte cmdSet, byte cmd) {
        this.proxy = proxy;
        this.pkt = new Packet();
        this.id = this.pkt.id;
        this.pkt.cmdSet = cmdSet;
        this.pkt.cmd = cmd;
    }

    PacketStream(ProxyListener proxy, int id, byte flags, short errorCode) {
        this.pkt = new Packet();
        this.proxy = proxy;
        this.pkt.id = id;
        this.id = id;
        this.pkt.errorCode = errorCode;
        this.pkt.flags = flags;
    }

    PacketStream(ProxyListener proxy, Packet p) {
        this.pkt = p;
        this.proxy = proxy;
        this.id = p.id;
        this.data = p.data;
    }

    int id() {
        return this.id;
    }

    void send() throws ProxyConnectionException {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.proxy.send(this.pkt);
            this.isCommitted = true;
        }
    }

    void waitForReply() throws PacketStreamException {
        if (!this.isCommitted) {
            throw new ProxyConnectionException("waitForReply without send");
        }
        this.proxy.waitForReply(this.pkt);
        if (this.pkt.errorCode != 0) {
            throw new PacketStreamException(String.valueOf(this.pkt.errorCode));
        }
        this.data = this.pkt.data;
    }

    void writeBoolean(boolean data) {
        if (data) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte data) {
        this.dataStream.write(data);
    }

    void writeChar(char data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeShort(short data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeInt(int data) {
        this.dataStream.write((byte)(data >>> 24 & 0xFF));
        this.dataStream.write((byte)(data >>> 16 & 0xFF));
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeLong(long data) {
        this.dataStream.write((byte)(data >>> 56 & 0xFFL));
        this.dataStream.write((byte)(data >>> 48 & 0xFFL));
        this.dataStream.write((byte)(data >>> 40 & 0xFFL));
        this.dataStream.write((byte)(data >>> 32 & 0xFFL));
        this.dataStream.write((byte)(data >>> 24 & 0xFFL));
        this.dataStream.write((byte)(data >>> 16 & 0xFFL));
        this.dataStream.write((byte)(data >>> 8 & 0xFFL));
        this.dataStream.write((byte)(data >>> 0 & 0xFFL));
    }

    void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    void writeID(int size, long data) {
        if (size == 8) {
            this.writeLong(data);
        } else {
            this.writeInt((int)data);
        }
    }

    void writeByteArray(byte[] data) {
        this.dataStream.write(data, 0, data.length);
    }

    void writeString(String string) {
        try {
            byte[] stringBytes = string.getBytes("UTF8");
            this.writeInt(stringBytes.length);
            this.writeByteArray(stringBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert string to UTF8 bytes");
        }
    }

    byte readByte() throws PacketStreamException {
        this.checkCursor(1);
        return this.data[this.outCursor++];
    }

    boolean readBoolean() throws PacketStreamException {
        byte ret = this.readByte();
        return ret != 0;
    }

    char readChar() throws PacketStreamException {
        this.checkCursor(2);
        int b1 = this.data[this.outCursor++] & 0xFF;
        int b2 = this.data[this.outCursor++] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    short readShort() throws PacketStreamException {
        return (short)this.readChar();
    }

    int readInt() throws PacketStreamException {
        this.checkCursor(4);
        return ((this.data[this.outCursor++] & 0xFF) << 24) + ((this.data[this.outCursor++] & 0xFF) << 16) + ((this.data[this.outCursor++] & 0xFF) << 8) + (this.data[this.outCursor++] & 0xFF);
    }

    long readLong() throws PacketStreamException {
        return ((long)this.readInt() << 32) + (long)this.readInt();
    }

    double readDouble() throws PacketStreamException {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() throws PacketStreamException {
        String ret;
        int len = this.readInt();
        this.checkCursor(len);
        try {
            ret = new String(this.data, this.outCursor, len, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PacketStreamException();
        }
        this.outCursor += len;
        return ret;
    }

    private long readID(int size) throws PacketStreamException {
        if (size == 8) {
            return this.readLong();
        }
        return this.readInt();
    }

    int skipBytes(int n) throws PacketStreamException {
        this.checkCursor(n);
        this.outCursor += n;
        return n;
    }

    byte cmd() {
        return this.pkt.cmd;
    }

    void checkCursor(int size) throws PacketStreamException {
        if (this.outCursor + size > this.data.length) {
            throw new PacketStreamException("Reading past buffer");
        }
    }
}

