/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Packet;
import kdp.PacketStream;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;

abstract class ProxyListener
extends Thread {
    int verbose = 0;
    static int method_index_base = 0;
    static boolean VM_Version_3 = false;
    static boolean proxyMode = false;
    static int suspendCount = 0;
    final int METHOD_BASE_SHIFT = 15;
    final int METHOD_BASE_BITS = 98304;
    final int METHOD_BASE_ONE_FLAG = 2;
    final int KVM_VERSION_3_SHIFT = 17;
    final int KVM_VERSION_3_BITS = 393216;
    final int KVM_VERSION_3_FLAG = 2;
    final int MAJOR_VERSION = 1;
    final int MINOR_VERSION = 4;
    Map waitingQueue = new HashMap(8, 0.75f);
    protected List packetQueue = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPacket(Packet p) {
        if (p == null) {
            List list = this.packetQueue;
            synchronized (list) {
                this.packetQueue.notify();
            }
            return;
        }
        List list = this.packetQueue;
        synchronized (list) {
            this.packetQueue.add(p);
            this.packetQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet waitForPacket() {
        List list = this.packetQueue;
        synchronized (list) {
            while (this.packetQueue.size() == 0) {
                try {
                    this.packetQueue.wait();
                }
                catch (InterruptedException e) {
                    Log.LOGN(3, this + " waitForPacket Interrupted");
                    throw new ProxyConnectionException();
                }
            }
        }
        return (Packet)this.packetQueue.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replyReceived(Packet p) {
        Packet p2;
        if (p == null) {
            Map map = this.waitingQueue;
            synchronized (map) {
                Iterator iter = this.waitingQueue.values().iterator();
                while (iter.hasNext()) {
                    Packet p22;
                    Packet packet = p22 = (Packet)iter.next();
                    synchronized (packet) {
                        p22.notify();
                    }
                }
            }
            return;
        }
        String idString = String.valueOf(p.id);
        Object object = this.waitingQueue;
        synchronized (object) {
            p2 = (Packet)this.waitingQueue.get(idString);
            if (p2 != null) {
                this.waitingQueue.remove(idString);
            }
        }
        if (p2 == null) {
            System.err.println("Received reply with no sender!");
            return;
        }
        p2.errorCode = p.errorCode;
        p2.data = p.data;
        p2.replied = true;
        object = p2;
        synchronized (object) {
            p2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReply(Packet p) {
        Packet packet = p;
        synchronized (packet) {
            while (!p.replied) {
                try {
                    p.wait();
                }
                catch (InterruptedException e) {
                    System.out.println(this + " waitForReply Interrupted");
                    throw new ProxyConnectionException();
                }
            }
            if (!p.replied) {
                throw new RuntimeException();
            }
        }
    }

    public void verbose(int lvl) {
        this.verbose = lvl;
    }

    public abstract void send(Packet var1) throws ProxyConnectionException;

    public abstract void setStop();

    protected void vp(int vlevel, String str) {
        if (this.verbose >= vlevel) {
            System.out.print(str);
        }
    }

    protected void vpe(int vlevel, String str) {
        if (this.verbose == vlevel) {
            this.vp(vlevel, str);
        }
    }

    class MethodID {
        long _method_id_long;
        int _method_id_int;

        public MethodID() {
        }

        public MethodID(int class_id, int method_id) {
            if (VM_Version_3) {
                this._method_id_long = ((long)class_id << 32) + (long)method_id;
            } else {
                this._method_id_int = method_id;
            }
        }

        protected int readMethodPart(PacketStream ps) throws PacketStreamException {
            if (VM_Version_3) {
                this._method_id_long = ps.readLong();
                return this.methodPart(this._method_id_long);
            }
            this._method_id_int = ps.readInt();
            return this._method_id_int;
        }

        protected int methodPart(long mid) {
            return (int)(mid & 0xFFFFFFFFFFFFFFFFL);
        }

        protected void setMethodPart(int id) {
            this._method_id_int = id;
            if (VM_Version_3) {
                this._method_id_long = this._method_id_long & 0xFFFFFFFF00000000L | (long)id;
            }
        }

        protected void writeMethodID(PacketStream ps) throws PacketStreamException {
            if (VM_Version_3) {
                ps.writeLong(this._method_id_long);
            } else {
                ps.writeInt(this._method_id_int);
            }
        }

        public String toString() {
            if (VM_Version_3) {
                return Long.toHexString(this._method_id_long);
            }
            return Integer.toHexString(this._method_id_int);
        }
    }
}

