/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import kdp.Log;
import kdp.Packet;
import kdp.ProxyListener;

class SocketConnection
implements Runnable {
    Socket socket;
    DataOutputStream out;
    DataInputStream in;
    ProxyListener proxy;

    SocketConnection(ProxyListener proxy, Socket socket) throws IOException {
        this.proxy = proxy;
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte receiveByte() throws IOException {
        int b = this.in.read();
        return (byte)b;
    }

    public void sendByte(byte b) throws IOException {
        this.out.write(b);
        this.out.flush();
    }

    public void run() {
        try {
            while (true) {
                Packet p = this.receivePacket();
                if ((p.flags & 0xFFFFFF80) == 0 || p.id >= 0) {
                    this.proxy.newPacket(p);
                    continue;
                }
                this.proxy.replyReceived(p);
            }
        }
        catch (Exception e) {
            Log.LOGN(4, "Socket exception in " + this.proxy + e + " ...exiting");
            this.proxy.setStop();
            return;
        }
    }

    public Packet receivePacket() throws IOException {
        int count;
        Packet p = new Packet();
        int length = this.in.readInt();
        p.id = this.in.readInt();
        p.flags = this.in.readByte();
        if ((p.flags & 0xFFFFFF80) == 0) {
            p.cmdSet = this.in.readByte();
            p.cmd = this.in.readByte();
        } else {
            p.errorCode = this.in.readShort();
        }
        if ((length -= 11) < 0) {
            throw new IOException("packet length < 0");
        }
        p.data = new byte[length];
        for (int n = 0; n < p.data.length; n += count) {
            count = this.in.read(p.data, n, p.data.length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return p;
    }

    public void send(Packet p) throws IOException {
        int length = p.data.length + 11;
        this.out.writeInt(length);
        this.out.writeInt(p.id);
        this.out.write(p.flags);
        if ((p.flags & 0xFFFFFF80) == 0) {
            this.out.write(p.cmdSet);
            this.out.write(p.cmd);
        } else {
            this.out.writeShort(p.errorCode);
        }
        this.out.write(p.data);
        this.out.flush();
    }
}

