/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;

public class AccessFlags {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_ARRAY = 4096;
    private int flags;

    public AccessFlags(DataInputStream iStream) throws IOException {
        this.flags = iStream.readUnsignedShort();
    }

    public String toString() {
        String s = new String("Class Access Flags:\t");
        if ((this.flags & 1) > 0) {
            s = s + "public ";
        }
        if ((this.flags & 0x10) > 0) {
            s = s + "final ";
        }
        if ((this.flags & 0x20) > 0) {
            s = s + "super ";
        }
        if ((this.flags & 0x200) > 0) {
            s = s + "interface ";
        }
        if ((this.flags & 0x400) > 0) {
            s = s + "abstract";
        }
        return s;
    }

    public byte getJDWPTypeTag() {
        if ((this.flags & 0x1000) > 0) {
            return 3;
        }
        if ((this.flags & 0x200) > 0) {
            return 2;
        }
        return 1;
    }

    public int getRawAccessFlags() {
        return this.flags;
    }
}

