/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import kdp.Log;
import kdp.classparser.AccessFlags;
import kdp.classparser.FieldInfo;
import kdp.classparser.FileReference;
import kdp.classparser.MethodInfo;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.SourceFileAttribute;
import kdp.classparser.constantpoolclasses.ConstantClassInfo;
import kdp.classparser.constantpoolclasses.ConstantDoubleInfo;
import kdp.classparser.constantpoolclasses.ConstantFieldrefInfo;
import kdp.classparser.constantpoolclasses.ConstantFloatInfo;
import kdp.classparser.constantpoolclasses.ConstantIntegerInfo;
import kdp.classparser.constantpoolclasses.ConstantInterfaceMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantLongInfo;
import kdp.classparser.constantpoolclasses.ConstantMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantNameAndTypeInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantStringInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ClassFile {
    private static final int OBJECT_SUPER_CLASS_ID = 0;
    final byte TYPE_TAG_ARRAY = (byte)3;
    private String baseName;
    private String className;
    private String classSignature;
    private FileReference classFile;
    private int magic;
    private int majorVersion;
    private int minorVersion;
    private int constantPoolCount;
    private ConstantPoolInfo[] constantPool;
    private AccessFlags accessFlags;
    private int thisClass;
    private int superClass;
    private int interfacesCount;
    private int[] interfaces;
    private int fieldsCount;
    private FieldInfo[] fieldInfo;
    private int methodsCount;
    private MethodInfo[] methodInfo;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private byte typeTag;
    int classID;
    int classStatus;

    public ClassFile(FileReference classFile, String className, byte typeTag) {
        this.classFile = classFile;
        this.className = className;
        int index = className.lastIndexOf(47);
        this.baseName = index != -1 ? className.substring(index + 1) : className;
        this.typeTag = typeTag;
        this.classSignature = typeTag == 3 ? className : "L" + className.replace('.', '/') + ";";
    }

    public boolean equals(String newclassName) {
        return this.className.equals(newclassName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public String getClassFileName() {
        if (this.classFile == null) {
            return "NULL";
        }
        return this.classFile.toString();
    }

    public byte getJDWPTypeTag() {
        return this.typeTag;
    }

    public void setClassID(int classID) {
        this.classID = classID;
    }

    public int getClassID() {
        return this.classID;
    }

    public void setClassStatus(int status) {
        this.classStatus = status;
    }

    public int getClassStatus() {
        return this.classStatus;
    }

    public void readClassFile() throws IOException {
        try {
            DataInputStream iStream = new DataInputStream(this.classFile.getInputStream());
            this.magic = iStream.readInt();
            this.minorVersion = iStream.readUnsignedShort();
            this.majorVersion = iStream.readUnsignedShort();
            this.readConstantPool(iStream);
            this.accessFlags = new AccessFlags(iStream);
            this.thisClass = iStream.readUnsignedShort();
            this.superClass = iStream.readUnsignedShort();
            this.readInterfaces(iStream);
            this.readFieldInfo(iStream);
            this.readMethodInfo(iStream);
            this.readAttributes(iStream);
            iStream.close();
        }
        catch (IOException e) {
            System.out.println("Caught IO Exception - " + e.getMessage());
            throw e;
        }
    }

    private int readConstantPool(DataInputStream iStream) throws IOException {
        this.constantPoolCount = iStream.readUnsignedShort();
        this.constantPool = new ConstantPoolInfo[this.constantPoolCount];
        block13: for (int lcv = 1; lcv < this.constantPoolCount; ++lcv) {
            byte tag = iStream.readByte();
            switch (tag) {
                case 7: {
                    this.constantPool[lcv] = new ConstantClassInfo(iStream);
                    continue block13;
                }
                case 9: {
                    this.constantPool[lcv] = new ConstantFieldrefInfo(iStream);
                    continue block13;
                }
                case 10: {
                    this.constantPool[lcv] = new ConstantMethodrefInfo(iStream);
                    continue block13;
                }
                case 11: {
                    this.constantPool[lcv] = new ConstantInterfaceMethodrefInfo(iStream);
                    continue block13;
                }
                case 8: {
                    this.constantPool[lcv] = new ConstantStringInfo(iStream);
                    continue block13;
                }
                case 3: {
                    this.constantPool[lcv] = new ConstantIntegerInfo(iStream);
                    continue block13;
                }
                case 4: {
                    this.constantPool[lcv] = new ConstantFloatInfo(iStream);
                    continue block13;
                }
                case 5: {
                    this.constantPool[lcv] = new ConstantLongInfo(iStream);
                    ++lcv;
                    continue block13;
                }
                case 6: {
                    this.constantPool[lcv] = new ConstantDoubleInfo(iStream);
                    ++lcv;
                    continue block13;
                }
                case 12: {
                    this.constantPool[lcv] = new ConstantNameAndTypeInfo(iStream);
                    continue block13;
                }
                case 1: {
                    this.constantPool[lcv] = new ConstantUtf8Info(iStream);
                    continue block13;
                }
            }
        }
        return this.constantPoolCount;
    }

    private int readInterfaces(DataInputStream iStream) throws IOException {
        this.interfacesCount = iStream.readUnsignedShort();
        if (this.interfacesCount == 0) {
            return this.interfacesCount;
        }
        this.interfaces = new int[this.interfacesCount];
        for (int lcv = 0; lcv < this.interfacesCount; ++lcv) {
            this.interfaces[lcv] = iStream.readUnsignedShort();
        }
        return this.interfacesCount;
    }

    private int readFieldInfo(DataInputStream iStream) throws IOException {
        this.fieldsCount = iStream.readUnsignedShort();
        this.fieldInfo = new FieldInfo[this.fieldsCount];
        for (int lcv = 0; lcv < this.fieldsCount; ++lcv) {
            this.fieldInfo[lcv] = new FieldInfo(iStream, this.constantPool);
        }
        return this.fieldsCount;
    }

    public MethodInfo lookUpMethodByLineNumber(int lineNumber) {
        boolean found = false;
        int index = 0;
        while (!found && index < this.methodsCount) {
            if (this.methodInfo[index].containsLine(lineNumber)) {
                found = true;
                continue;
            }
            ++index;
        }
        return found ? this.methodInfo[index] : null;
    }

    private int readMethodInfo(DataInputStream iStream) throws IOException {
        this.methodsCount = iStream.readUnsignedShort();
        this.methodInfo = new MethodInfo[this.methodsCount];
        for (int lcv = 0; lcv < this.methodsCount; ++lcv) {
            this.methodInfo[lcv] = new MethodInfo(iStream, this.constantPool);
        }
        return this.methodsCount;
    }

    private int readAttributes(DataInputStream iStream) throws IOException {
        this.attributesCount = iStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            this.attributes[lcv] = new AttributeInfo(iStream, this.constantPool);
        }
        return this.attributesCount;
    }

    public MethodInfo getMethodInfoByName(String methodName, String sig) {
        for (int i = 0; i < this.methodsCount; ++i) {
            if (!this.methodInfo[i].getName().equals(methodName) || !this.methodInfo[i].getSignatureRaw().equals(sig)) continue;
            return this.methodInfo[i];
        }
        return null;
    }

    public MethodInfo getMethodInfoByIndex(int methodIndex) {
        if (this.methodInfo == null || methodIndex > this.methodInfo.length) {
            return null;
        }
        return this.methodInfo[methodIndex];
    }

    public List getAllMethodInfo() {
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        for (int i = 0; this.methodInfo != null && i < this.methodInfo.length; ++i) {
            vector.add(this.methodInfo[i]);
        }
        return vector;
    }

    public List getAllFieldInfo() {
        Vector<FieldInfo> vector = new Vector<FieldInfo>();
        for (int i = 0; this.fieldInfo != null && i < this.fieldInfo.length; ++i) {
            vector.add(this.fieldInfo[i]);
        }
        return vector;
    }

    public List getAllInterfaces() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.interfacesCount; ++i) {
            int nameIndex = ((ConstantClassInfo)this.constantPool[this.interfaces[i]]).getNameIndex();
            ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[nameIndex];
            Log.LOGN(3, "interface: " + utf8Info.toString());
            vector.add(utf8Info.toString());
        }
        return vector;
    }

    public String getSuperClass() {
        if (this.superClass == 0) {
            return "";
        }
        ConstantClassInfo c = (ConstantClassInfo)this.constantPool[this.superClass];
        int nameIndex = c.getNameIndex();
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[nameIndex];
        return utf8Info.toString();
    }

    public void print(PrintStream out) {
        int lcv;
        out.println(this.accessFlags);
        ConstantClassInfo c = (ConstantClassInfo)this.constantPool[this.thisClass];
        int nameIndex = c.getNameIndex();
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[nameIndex];
        out.println("This Class:\t\t" + StringParser.parseClassName(utf8Info.toString()));
        String sc = this.getSuperClass();
        out.print("Superclass: ");
        if (sc.equals("")) {
            out.println("None");
        } else {
            out.println(sc);
        }
        if (this.interfacesCount > 0) {
            for (lcv = 0; lcv < this.interfacesCount; ++lcv) {
                c = (ConstantClassInfo)this.constantPool[this.interfaces[lcv]];
                nameIndex = c.getNameIndex();
                utf8Info = (ConstantUtf8Info)this.constantPool[nameIndex];
                out.println("Interfaces:\t\t" + StringParser.parseClassName(utf8Info.toString()));
            }
        }
        out.println("Constant Pool: ");
        lcv = 1;
        while (lcv < this.constantPool.length) {
            out.println(this.constantPool[lcv].toString());
            if (this.constantPool[lcv] instanceof ConstantLongInfo || this.constantPool[lcv] instanceof ConstantDoubleInfo) {
                lcv += 2;
                continue;
            }
            ++lcv;
        }
        for (lcv = 0; lcv < this.fieldsCount; ++lcv) {
            out.println(this.fieldInfo[lcv].toString());
        }
        for (lcv = 0; lcv < this.methodsCount; ++lcv) {
            out.println(this.methodInfo[lcv].toString());
        }
        for (lcv = 0; lcv < this.attributesCount; ++lcv) {
            out.println(this.attributes[lcv].toString());
        }
    }

    public List getVariableTableForMethodIndex(int methodIndex) {
        MethodInfo mi = null;
        boolean i = false;
        boolean attributeCount = false;
        List list = null;
        mi = this.getMethodInfoByIndex(methodIndex);
        if (mi != null) {
            list = mi.getLocalVariables();
        }
        return list;
    }

    public int getRawAccessFlags() {
        return this.accessFlags.getRawAccessFlags();
    }

    public SourceFileAttribute getSourceAttribute() {
        int attrIndex = 0;
        boolean found = false;
        while (!found && attrIndex < this.attributesCount) {
            if (this.attributes[attrIndex].getType() == 7) {
                found = true;
                continue;
            }
            ++attrIndex;
        }
        if (found) {
            AttributeInfo attrInfo = this.attributes[attrIndex];
            return (SourceFileAttribute)attrInfo.getInfo();
        }
        return null;
    }
}

