/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kdp.Log;
import kdp.classparser.ClassFile;
import kdp.classparser.FileReference;
import kdp.classparser.SearchPath;

public class ClassManager {
    SearchPath path = null;
    public Map classMap = new HashMap(128, 0.75f);

    public ClassManager() {
    }

    public ClassManager(SearchPath path) {
        this();
        this.path = path;
    }

    private ClassFile loadClass(String className, FileReference file, byte typetag) {
        Log.LOGN(3, "loadclass: " + file);
        ClassFile cf = new ClassFile(file, className, typetag);
        try {
            cf.readClassFile();
        }
        catch (Exception e) {
            Log.LOGN(2, "Error loading: " + file);
            cf = null;
        }
        return cf;
    }

    public ClassFile findClass(byte typeTag, String className) {
        ClassFile cf = null;
        Collection cVals = this.classMap.values();
        Iterator cIter = cVals.iterator();
        while (cIter.hasNext()) {
            cf = (ClassFile)cIter.next();
            if (!cf.equals(className)) continue;
            return cf;
        }
        return null;
    }

    public ClassFile findClass(int cid, String className, byte typetag, int status) {
        ClassFile cf = null;
        cf = (ClassFile)this.classMap.get(new Integer(cid));
        if (cf != null) {
            cf.setClassStatus(status);
            return cf;
        }
        if (typetag == 3) {
            Log.LOGN(4, "findclass: Array class " + className);
            cf = new ClassFile(null, className, typetag);
            this.classMap.put(new Integer(cid), cf);
            cf.setClassID(cid);
            cf.setClassStatus(status);
            return cf;
        }
        if (this.path != null) {
            Log.LOGN(4, "findclass: finding " + className);
            FileReference file = this.path.resolve(className);
            if (file != null && (cf = this.loadClass(className, file, typetag)) != null) {
                this.classMap.put(new Integer(cid), cf);
                cf.setClassID(cid);
                cf.setClassStatus(status);
                return cf;
            }
        }
        return null;
    }
}

